<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Product StructType
 * @subpackage Structs
 */
class Product extends AbstractStructBase
{
    /**
     * The productId
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - ref: ns3:productId
     * @var string
     */
    public $productId;
    /**
     * The productName
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 256
     * - minLength: 1
     * - ref: ns3:productName
     * @var string
     */
    public $productName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 2048
     * - maxOccurs: unbounded
     * - minLength: 1
     * - ref: ns3:description
     * @var string[]
     */
    public $description;
    /**
     * The priceExpiresDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns3:priceExpiresDate
     * @var string
     */
    public $priceExpiresDate;
    /**
     * The ProductMarketingPointArray
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ProductMarketingPointArray
     */
    public $ProductMarketingPointArray;
    /**
     * The ProductKeywordArray
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ProductKeywordArray
     */
    public $ProductKeywordArray;
    /**
     * The productBrand
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns3:productBrand
     * @var string
     */
    public $productBrand;
    /**
     * The export
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $export;
    /**
     * The ProductCategoryArray
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ProductCategoryArray
     */
    public $ProductCategoryArray;
    /**
     * The RelatedProductArray
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\RelatedProductArray
     */
    public $RelatedProductArray;
    /**
     * The primaryImageUrl
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 1024
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns3:primaryImageUrl
     * @var string
     */
    public $primaryImageUrl;
    /**
     * The ProductPriceGroupArray
     * @var \ArrayType\ProductPriceGroupArray
     */
    public $ProductPriceGroupArray;
    /**
     * The complianceInfoAvailable
     * Meta information extracted from the WSDL
     * - ref: ns3:complianceInfoAvailable
     * @var bool
     */
    public $complianceInfoAvailable;
    /**
     * The unspscCommodityCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $unspscCommodityCode;
    /**
     * The LocationDecorationArray
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns3:LocationDecorationArray
     * @var \ArrayType\LocationDecorationArray
     */
    public $LocationDecorationArray;
    /**
     * The ProductPartArray
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ProductPartArray
     */
    public $ProductPartArray;
    /**
     * The lastChangeDate
     * @var string
     */
    public $lastChangeDate;
    /**
     * The creationDate
     * @var string
     */
    public $creationDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - ref: ns3:endDate
     * @var string
     */
    public $endDate;
    /**
     * The effectiveDate
     * Meta information extracted from the WSDL
     * - ref: ns3:effectiveDate
     * @var string
     */
    public $effectiveDate;
    /**
     * The isCaution
     * Meta information extracted from the WSDL
     * - ref: ns3:isCaution
     * @var bool
     */
    public $isCaution;
    /**
     * The cautionComment
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 1024
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns3:cautionComment
     * @var string
     */
    public $cautionComment;
    /**
     * The isCloseout
     * Meta information extracted from the WSDL
     * - ref: ns3:isCloseout
     * @var bool
     */
    public $isCloseout;
    /**
     * The lineName
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns3:lineName
     * @var string
     */
    public $lineName;
    /**
     * The defaultSetupCharge
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 256
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns3:defaultSetupCharge
     * @var string
     */
    public $defaultSetupCharge;
    /**
     * The defaultRunCharge
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 256
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns3:defaultRunCharge
     * @var string
     */
    public $defaultRunCharge;
    /**
     * The imprintSize
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 256
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns3:imprintSize
     * @var string
     */
    public $imprintSize;
    /**
     * The FobPointArray
     * Meta information extracted from the WSDL
     * - ref: ns3:FobPointArray
     * @var \ArrayType\FobPointArray
     */
    public $FobPointArray;
    /**
     * Constructor method for Product
     * @uses Product::setProductId()
     * @uses Product::setProductName()
     * @uses Product::setDescription()
     * @uses Product::setPriceExpiresDate()
     * @uses Product::setProductMarketingPointArray()
     * @uses Product::setProductKeywordArray()
     * @uses Product::setProductBrand()
     * @uses Product::setExport()
     * @uses Product::setProductCategoryArray()
     * @uses Product::setRelatedProductArray()
     * @uses Product::setPrimaryImageUrl()
     * @uses Product::setProductPriceGroupArray()
     * @uses Product::setComplianceInfoAvailable()
     * @uses Product::setUnspscCommodityCode()
     * @uses Product::setLocationDecorationArray()
     * @uses Product::setProductPartArray()
     * @uses Product::setLastChangeDate()
     * @uses Product::setCreationDate()
     * @uses Product::setEndDate()
     * @uses Product::setEffectiveDate()
     * @uses Product::setIsCaution()
     * @uses Product::setCautionComment()
     * @uses Product::setIsCloseout()
     * @uses Product::setLineName()
     * @uses Product::setDefaultSetupCharge()
     * @uses Product::setDefaultRunCharge()
     * @uses Product::setImprintSize()
     * @uses Product::setFobPointArray()
     * @param string $productId
     * @param string $productName
     * @param string[] $description
     * @param string $priceExpiresDate
     * @param \ArrayType\ProductMarketingPointArray $productMarketingPointArray
     * @param \ArrayType\ProductKeywordArray $productKeywordArray
     * @param string $productBrand
     * @param bool $export
     * @param \ArrayType\ProductCategoryArray $productCategoryArray
     * @param \ArrayType\RelatedProductArray $relatedProductArray
     * @param string $primaryImageUrl
     * @param \ArrayType\ProductPriceGroupArray $productPriceGroupArray
     * @param bool $complianceInfoAvailable
     * @param int $unspscCommodityCode
     * @param \ArrayType\LocationDecorationArray $locationDecorationArray
     * @param \ArrayType\ProductPartArray $productPartArray
     * @param string $lastChangeDate
     * @param string $creationDate
     * @param string $endDate
     * @param string $effectiveDate
     * @param bool $isCaution
     * @param string $cautionComment
     * @param bool $isCloseout
     * @param string $lineName
     * @param string $defaultSetupCharge
     * @param string $defaultRunCharge
     * @param string $imprintSize
     * @param \ArrayType\FobPointArray $fobPointArray
     */
    public function __construct($productId = null, $productName = null, array $description = array(), $priceExpiresDate = null, \ArrayType\ProductMarketingPointArray $productMarketingPointArray = null, \ArrayType\ProductKeywordArray $productKeywordArray = null, $productBrand = null, $export = null, \ArrayType\ProductCategoryArray $productCategoryArray = null, \ArrayType\RelatedProductArray $relatedProductArray = null, $primaryImageUrl = null, \ArrayType\ProductPriceGroupArray $productPriceGroupArray = null, $complianceInfoAvailable = null, $unspscCommodityCode = null, \ArrayType\LocationDecorationArray $locationDecorationArray = null, \ArrayType\ProductPartArray $productPartArray = null, $lastChangeDate = null, $creationDate = null, $endDate = null, $effectiveDate = null, $isCaution = null, $cautionComment = null, $isCloseout = null, $lineName = null, $defaultSetupCharge = null, $defaultRunCharge = null, $imprintSize = null, \ArrayType\FobPointArray $fobPointArray = null)
    {
        $this
            ->setProductId($productId)
            ->setProductName($productName)
            ->setDescription($description)
            ->setPriceExpiresDate($priceExpiresDate)
            ->setProductMarketingPointArray($productMarketingPointArray)
            ->setProductKeywordArray($productKeywordArray)
            ->setProductBrand($productBrand)
            ->setExport($export)
            ->setProductCategoryArray($productCategoryArray)
            ->setRelatedProductArray($relatedProductArray)
            ->setPrimaryImageUrl($primaryImageUrl)
            ->setProductPriceGroupArray($productPriceGroupArray)
            ->setComplianceInfoAvailable($complianceInfoAvailable)
            ->setUnspscCommodityCode($unspscCommodityCode)
            ->setLocationDecorationArray($locationDecorationArray)
            ->setProductPartArray($productPartArray)
            ->setLastChangeDate($lastChangeDate)
            ->setCreationDate($creationDate)
            ->setEndDate($endDate)
            ->setEffectiveDate($effectiveDate)
            ->setIsCaution($isCaution)
            ->setCautionComment($cautionComment)
            ->setIsCloseout($isCloseout)
            ->setLineName($lineName)
            ->setDefaultSetupCharge($defaultSetupCharge)
            ->setDefaultRunCharge($defaultRunCharge)
            ->setImprintSize($imprintSize)
            ->setFobPointArray($fobPointArray);
    }
    /**
     * Get productId value
     * @return string|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param string $productId
     * @return \StructType\Product
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($productId) && mb_strlen($productId) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($productId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($productId) && mb_strlen($productId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get productName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->productName;
    }
    /**
     * Set productName value
     * @param string $productName
     * @return \StructType\Product
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($productName) && mb_strlen($productName) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($productName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($productName) && mb_strlen($productName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($productName)), __LINE__);
        }
        $this->productName = $productName;
        return $this;
    }
    /**
     * Get description value
     * @return string[]|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productDescriptionItem) {
            // validation for constraint: itemType
            if (!is_string($productDescriptionItem)) {
                $invalidValues[] = is_object($productDescriptionItem) ? get_class($productDescriptionItem) : sprintf('%s(%s)', gettype($productDescriptionItem), var_export($productDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The description property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForMaxLengthConstraintFromSetDescription($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productDescriptionItem) {
            // validation for constraint: maxLength(2048)
            if (mb_strlen($productDescriptionItem) > 2048) {
                $invalidValues[] = var_export($productDescriptionItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 2048', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForMinLengthConstraintFromSetDescription($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productDescriptionItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($productDescriptionItem) < 1) {
                $invalidValues[] = var_export($productDescriptionItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set description value
     * @throws \InvalidArgumentException
     * @param string[] $description
     * @return \StructType\Product
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(2048)
        if ('' !== ($descriptionMaxLengthErrorMessage = self::validateDescriptionForMaxLengthConstraintFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($descriptionMinLengthErrorMessage = self::validateDescriptionForMinLengthConstraintFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionMinLengthErrorMessage, __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Add item to description value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Product
     */
    public function addToDescription($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The description property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(2048)
        if (mb_strlen($item) > 2048) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2048', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        $this->description[] = $item;
        return $this;
    }
    /**
     * Get priceExpiresDate value
     * @return string|null
     */
    public function getPriceExpiresDate()
    {
        return $this->priceExpiresDate;
    }
    /**
     * Set priceExpiresDate value
     * @param string $priceExpiresDate
     * @return \StructType\Product
     */
    public function setPriceExpiresDate($priceExpiresDate = null)
    {
        // validation for constraint: string
        if (!is_null($priceExpiresDate) && !is_string($priceExpiresDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceExpiresDate, true), gettype($priceExpiresDate)), __LINE__);
        }
        $this->priceExpiresDate = $priceExpiresDate;
        return $this;
    }
    /**
     * Get ProductMarketingPointArray value
     * @return \ArrayType\ProductMarketingPointArray|null
     */
    public function getProductMarketingPointArray()
    {
        return $this->ProductMarketingPointArray;
    }
    /**
     * Set ProductMarketingPointArray value
     * @param \ArrayType\ProductMarketingPointArray $productMarketingPointArray
     * @return \StructType\Product
     */
    public function setProductMarketingPointArray(\ArrayType\ProductMarketingPointArray $productMarketingPointArray = null)
    {
        $this->ProductMarketingPointArray = $productMarketingPointArray;
        return $this;
    }
    /**
     * Get ProductKeywordArray value
     * @return \ArrayType\ProductKeywordArray|null
     */
    public function getProductKeywordArray()
    {
        return $this->ProductKeywordArray;
    }
    /**
     * Set ProductKeywordArray value
     * @param \ArrayType\ProductKeywordArray $productKeywordArray
     * @return \StructType\Product
     */
    public function setProductKeywordArray(\ArrayType\ProductKeywordArray $productKeywordArray = null)
    {
        $this->ProductKeywordArray = $productKeywordArray;
        return $this;
    }
    /**
     * Get productBrand value
     * @return string|null
     */
    public function getProductBrand()
    {
        return $this->productBrand;
    }
    /**
     * Set productBrand value
     * @param string $productBrand
     * @return \StructType\Product
     */
    public function setProductBrand($productBrand = null)
    {
        // validation for constraint: string
        if (!is_null($productBrand) && !is_string($productBrand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productBrand, true), gettype($productBrand)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($productBrand) && mb_strlen($productBrand) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($productBrand)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($productBrand) && mb_strlen($productBrand) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($productBrand)), __LINE__);
        }
        $this->productBrand = $productBrand;
        return $this;
    }
    /**
     * Get export value
     * @return bool|null
     */
    public function getExport()
    {
        return $this->export;
    }
    /**
     * Set export value
     * @param bool $export
     * @return \StructType\Product
     */
    public function setExport($export = null)
    {
        // validation for constraint: boolean
        if (!is_null($export) && !is_bool($export)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($export, true), gettype($export)), __LINE__);
        }
        $this->export = $export;
        return $this;
    }
    /**
     * Get ProductCategoryArray value
     * @return \ArrayType\ProductCategoryArray|null
     */
    public function getProductCategoryArray()
    {
        return $this->ProductCategoryArray;
    }
    /**
     * Set ProductCategoryArray value
     * @param \ArrayType\ProductCategoryArray $productCategoryArray
     * @return \StructType\Product
     */
    public function setProductCategoryArray(\ArrayType\ProductCategoryArray $productCategoryArray = null)
    {
        $this->ProductCategoryArray = $productCategoryArray;
        return $this;
    }
    /**
     * Get RelatedProductArray value
     * @return \ArrayType\RelatedProductArray|null
     */
    public function getRelatedProductArray()
    {
        return $this->RelatedProductArray;
    }
    /**
     * Set RelatedProductArray value
     * @param \ArrayType\RelatedProductArray $relatedProductArray
     * @return \StructType\Product
     */
    public function setRelatedProductArray(\ArrayType\RelatedProductArray $relatedProductArray = null)
    {
        $this->RelatedProductArray = $relatedProductArray;
        return $this;
    }
    /**
     * Get primaryImageUrl value
     * @return string|null
     */
    public function getPrimaryImageUrl()
    {
        return $this->primaryImageUrl;
    }
    /**
     * Set primaryImageUrl value
     * @param string $primaryImageUrl
     * @return \StructType\Product
     */
    public function setPrimaryImageUrl($primaryImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($primaryImageUrl) && !is_string($primaryImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryImageUrl, true), gettype($primaryImageUrl)), __LINE__);
        }
        // validation for constraint: maxLength(1024)
        if (!is_null($primaryImageUrl) && mb_strlen($primaryImageUrl) > 1024) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1024', mb_strlen($primaryImageUrl)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($primaryImageUrl) && mb_strlen($primaryImageUrl) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($primaryImageUrl)), __LINE__);
        }
        $this->primaryImageUrl = $primaryImageUrl;
        return $this;
    }
    /**
     * Get ProductPriceGroupArray value
     * @return \ArrayType\ProductPriceGroupArray|null
     */
    public function getProductPriceGroupArray()
    {
        return $this->ProductPriceGroupArray;
    }
    /**
     * Set ProductPriceGroupArray value
     * @param \ArrayType\ProductPriceGroupArray $productPriceGroupArray
     * @return \StructType\Product
     */
    public function setProductPriceGroupArray(\ArrayType\ProductPriceGroupArray $productPriceGroupArray = null)
    {
        $this->ProductPriceGroupArray = $productPriceGroupArray;
        return $this;
    }
    /**
     * Get complianceInfoAvailable value
     * @return bool|null
     */
    public function getComplianceInfoAvailable()
    {
        return $this->complianceInfoAvailable;
    }
    /**
     * Set complianceInfoAvailable value
     * @param bool $complianceInfoAvailable
     * @return \StructType\Product
     */
    public function setComplianceInfoAvailable($complianceInfoAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($complianceInfoAvailable) && !is_bool($complianceInfoAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($complianceInfoAvailable, true), gettype($complianceInfoAvailable)), __LINE__);
        }
        $this->complianceInfoAvailable = $complianceInfoAvailable;
        return $this;
    }
    /**
     * Get unspscCommodityCode value
     * @return int|null
     */
    public function getUnspscCommodityCode()
    {
        return $this->unspscCommodityCode;
    }
    /**
     * Set unspscCommodityCode value
     * @param int $unspscCommodityCode
     * @return \StructType\Product
     */
    public function setUnspscCommodityCode($unspscCommodityCode = null)
    {
        // validation for constraint: int
        if (!is_null($unspscCommodityCode) && !(is_int($unspscCommodityCode) || ctype_digit($unspscCommodityCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unspscCommodityCode, true), gettype($unspscCommodityCode)), __LINE__);
        }
        $this->unspscCommodityCode = $unspscCommodityCode;
        return $this;
    }
    /**
     * Get LocationDecorationArray value
     * @return \ArrayType\LocationDecorationArray|null
     */
    public function getLocationDecorationArray()
    {
        return $this->LocationDecorationArray;
    }
    /**
     * Set LocationDecorationArray value
     * @param \ArrayType\LocationDecorationArray $locationDecorationArray
     * @return \StructType\Product
     */
    public function setLocationDecorationArray(\ArrayType\LocationDecorationArray $locationDecorationArray = null)
    {
        $this->LocationDecorationArray = $locationDecorationArray;
        return $this;
    }
    /**
     * Get ProductPartArray value
     * @return \ArrayType\ProductPartArray|null
     */
    public function getProductPartArray()
    {
        return $this->ProductPartArray;
    }
    /**
     * Set ProductPartArray value
     * @param \ArrayType\ProductPartArray $productPartArray
     * @return \StructType\Product
     */
    public function setProductPartArray(\ArrayType\ProductPartArray $productPartArray = null)
    {
        $this->ProductPartArray = $productPartArray;
        return $this;
    }
    /**
     * Get lastChangeDate value
     * @return string|null
     */
    public function getLastChangeDate()
    {
        return $this->lastChangeDate;
    }
    /**
     * Set lastChangeDate value
     * @param string $lastChangeDate
     * @return \StructType\Product
     */
    public function setLastChangeDate($lastChangeDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastChangeDate) && !is_string($lastChangeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastChangeDate, true), gettype($lastChangeDate)), __LINE__);
        }
        $this->lastChangeDate = $lastChangeDate;
        return $this;
    }
    /**
     * Get creationDate value
     * @return string|null
     */
    public function getCreationDate()
    {
        return $this->creationDate;
    }
    /**
     * Set creationDate value
     * @param string $creationDate
     * @return \StructType\Product
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        $this->creationDate = $creationDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\Product
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get effectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->effectiveDate;
    }
    /**
     * Set effectiveDate value
     * @param string $effectiveDate
     * @return \StructType\Product
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->effectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get isCaution value
     * @return bool|null
     */
    public function getIsCaution()
    {
        return $this->isCaution;
    }
    /**
     * Set isCaution value
     * @param bool $isCaution
     * @return \StructType\Product
     */
    public function setIsCaution($isCaution = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCaution) && !is_bool($isCaution)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCaution, true), gettype($isCaution)), __LINE__);
        }
        $this->isCaution = $isCaution;
        return $this;
    }
    /**
     * Get cautionComment value
     * @return string|null
     */
    public function getCautionComment()
    {
        return $this->cautionComment;
    }
    /**
     * Set cautionComment value
     * @param string $cautionComment
     * @return \StructType\Product
     */
    public function setCautionComment($cautionComment = null)
    {
        // validation for constraint: string
        if (!is_null($cautionComment) && !is_string($cautionComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cautionComment, true), gettype($cautionComment)), __LINE__);
        }
        // validation for constraint: maxLength(1024)
        if (!is_null($cautionComment) && mb_strlen($cautionComment) > 1024) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1024', mb_strlen($cautionComment)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($cautionComment) && mb_strlen($cautionComment) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($cautionComment)), __LINE__);
        }
        $this->cautionComment = $cautionComment;
        return $this;
    }
    /**
     * Get isCloseout value
     * @return bool|null
     */
    public function getIsCloseout()
    {
        return $this->isCloseout;
    }
    /**
     * Set isCloseout value
     * @param bool $isCloseout
     * @return \StructType\Product
     */
    public function setIsCloseout($isCloseout = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCloseout) && !is_bool($isCloseout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCloseout, true), gettype($isCloseout)), __LINE__);
        }
        $this->isCloseout = $isCloseout;
        return $this;
    }
    /**
     * Get lineName value
     * @return string|null
     */
    public function getLineName()
    {
        return $this->lineName;
    }
    /**
     * Set lineName value
     * @param string $lineName
     * @return \StructType\Product
     */
    public function setLineName($lineName = null)
    {
        // validation for constraint: string
        if (!is_null($lineName) && !is_string($lineName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lineName, true), gettype($lineName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($lineName) && mb_strlen($lineName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($lineName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($lineName) && mb_strlen($lineName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($lineName)), __LINE__);
        }
        $this->lineName = $lineName;
        return $this;
    }
    /**
     * Get defaultSetupCharge value
     * @return string|null
     */
    public function getDefaultSetupCharge()
    {
        return $this->defaultSetupCharge;
    }
    /**
     * Set defaultSetupCharge value
     * @param string $defaultSetupCharge
     * @return \StructType\Product
     */
    public function setDefaultSetupCharge($defaultSetupCharge = null)
    {
        // validation for constraint: string
        if (!is_null($defaultSetupCharge) && !is_string($defaultSetupCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultSetupCharge, true), gettype($defaultSetupCharge)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($defaultSetupCharge) && mb_strlen($defaultSetupCharge) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($defaultSetupCharge)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($defaultSetupCharge) && mb_strlen($defaultSetupCharge) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($defaultSetupCharge)), __LINE__);
        }
        $this->defaultSetupCharge = $defaultSetupCharge;
        return $this;
    }
    /**
     * Get defaultRunCharge value
     * @return string|null
     */
    public function getDefaultRunCharge()
    {
        return $this->defaultRunCharge;
    }
    /**
     * Set defaultRunCharge value
     * @param string $defaultRunCharge
     * @return \StructType\Product
     */
    public function setDefaultRunCharge($defaultRunCharge = null)
    {
        // validation for constraint: string
        if (!is_null($defaultRunCharge) && !is_string($defaultRunCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultRunCharge, true), gettype($defaultRunCharge)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($defaultRunCharge) && mb_strlen($defaultRunCharge) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($defaultRunCharge)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($defaultRunCharge) && mb_strlen($defaultRunCharge) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($defaultRunCharge)), __LINE__);
        }
        $this->defaultRunCharge = $defaultRunCharge;
        return $this;
    }
    /**
     * Get imprintSize value
     * @return string|null
     */
    public function getImprintSize()
    {
        return $this->imprintSize;
    }
    /**
     * Set imprintSize value
     * @param string $imprintSize
     * @return \StructType\Product
     */
    public function setImprintSize($imprintSize = null)
    {
        // validation for constraint: string
        if (!is_null($imprintSize) && !is_string($imprintSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imprintSize, true), gettype($imprintSize)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($imprintSize) && mb_strlen($imprintSize) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($imprintSize)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($imprintSize) && mb_strlen($imprintSize) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($imprintSize)), __LINE__);
        }
        $this->imprintSize = $imprintSize;
        return $this;
    }
    /**
     * Get FobPointArray value
     * @return \ArrayType\FobPointArray|null
     */
    public function getFobPointArray()
    {
        return $this->FobPointArray;
    }
    /**
     * Set FobPointArray value
     * @param \ArrayType\FobPointArray $fobPointArray
     * @return \StructType\Product
     */
    public function setFobPointArray(\ArrayType\FobPointArray $fobPointArray = null)
    {
        $this->FobPointArray = $fobPointArray;
        return $this;
    }
}
