<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocationDecoration StructType
 * @subpackage Structs
 */
class LocationDecoration extends AbstractStructBase
{
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $locationName;
    /**
     * The maxImprintColors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $maxImprintColors;
    /**
     * The decorationName
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $decorationName;
    /**
     * The locationDecorationComboDefault
     * @var bool
     */
    public $locationDecorationComboDefault;
    /**
     * The priceIncludes
     * @var bool
     */
    public $priceIncludes;
    /**
     * Constructor method for LocationDecoration
     * @uses LocationDecoration::setLocationName()
     * @uses LocationDecoration::setMaxImprintColors()
     * @uses LocationDecoration::setDecorationName()
     * @uses LocationDecoration::setLocationDecorationComboDefault()
     * @uses LocationDecoration::setPriceIncludes()
     * @param string $locationName
     * @param int $maxImprintColors
     * @param string $decorationName
     * @param bool $locationDecorationComboDefault
     * @param bool $priceIncludes
     */
    public function __construct($locationName = null, $maxImprintColors = null, $decorationName = null, $locationDecorationComboDefault = null, $priceIncludes = null)
    {
        $this
            ->setLocationName($locationName)
            ->setMaxImprintColors($maxImprintColors)
            ->setDecorationName($decorationName)
            ->setLocationDecorationComboDefault($locationDecorationComboDefault)
            ->setPriceIncludes($priceIncludes);
    }
    /**
     * Get locationName value
     * @return string|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param string $locationName
     * @return \StructType\LocationDecoration
     */
    public function setLocationName($locationName = null)
    {
        // validation for constraint: string
        if (!is_null($locationName) && !is_string($locationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationName, true), gettype($locationName)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($locationName) && mb_strlen($locationName) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($locationName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($locationName) && mb_strlen($locationName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($locationName)), __LINE__);
        }
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get maxImprintColors value
     * @return int|null
     */
    public function getMaxImprintColors()
    {
        return $this->maxImprintColors;
    }
    /**
     * Set maxImprintColors value
     * @param int $maxImprintColors
     * @return \StructType\LocationDecoration
     */
    public function setMaxImprintColors($maxImprintColors = null)
    {
        // validation for constraint: int
        if (!is_null($maxImprintColors) && !(is_int($maxImprintColors) || ctype_digit($maxImprintColors))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxImprintColors, true), gettype($maxImprintColors)), __LINE__);
        }
        $this->maxImprintColors = $maxImprintColors;
        return $this;
    }
    /**
     * Get decorationName value
     * @return string|null
     */
    public function getDecorationName()
    {
        return $this->decorationName;
    }
    /**
     * Set decorationName value
     * @param string $decorationName
     * @return \StructType\LocationDecoration
     */
    public function setDecorationName($decorationName = null)
    {
        // validation for constraint: string
        if (!is_null($decorationName) && !is_string($decorationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($decorationName, true), gettype($decorationName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($decorationName) && mb_strlen($decorationName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($decorationName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($decorationName) && mb_strlen($decorationName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($decorationName)), __LINE__);
        }
        $this->decorationName = $decorationName;
        return $this;
    }
    /**
     * Get locationDecorationComboDefault value
     * @return bool|null
     */
    public function getLocationDecorationComboDefault()
    {
        return $this->locationDecorationComboDefault;
    }
    /**
     * Set locationDecorationComboDefault value
     * @param bool $locationDecorationComboDefault
     * @return \StructType\LocationDecoration
     */
    public function setLocationDecorationComboDefault($locationDecorationComboDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($locationDecorationComboDefault) && !is_bool($locationDecorationComboDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($locationDecorationComboDefault, true), gettype($locationDecorationComboDefault)), __LINE__);
        }
        $this->locationDecorationComboDefault = $locationDecorationComboDefault;
        return $this;
    }
    /**
     * Get priceIncludes value
     * @return bool|null
     */
    public function getPriceIncludes()
    {
        return $this->priceIncludes;
    }
    /**
     * Set priceIncludes value
     * @param bool $priceIncludes
     * @return \StructType\LocationDecoration
     */
    public function setPriceIncludes($priceIncludes = null)
    {
        // validation for constraint: boolean
        if (!is_null($priceIncludes) && !is_bool($priceIncludes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($priceIncludes, true), gettype($priceIncludes)), __LINE__);
        }
        $this->priceIncludes = $priceIncludes;
        return $this;
    }
}
