<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ShippingPackageArray ArrayType
 * @subpackage Arrays
 */
class ShippingPackageArray extends AbstractStructArrayBase
{
    /**
     * The ShippingPackage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns3:ShippingPackage
     * @var \StructType\ShippingPackage[]
     */
    public $ShippingPackage;
    /**
     * Constructor method for ShippingPackageArray
     * @uses ShippingPackageArray::setShippingPackage()
     * @param \StructType\ShippingPackage[] $shippingPackage
     */
    public function __construct(array $shippingPackage = array())
    {
        $this
            ->setShippingPackage($shippingPackage);
    }
    /**
     * Get ShippingPackage value
     * @return \StructType\ShippingPackage[]|null
     */
    public function getShippingPackage()
    {
        return $this->ShippingPackage;
    }
    /**
     * This method is responsible for validating the values passed to the setShippingPackage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShippingPackage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShippingPackageForArrayConstraintsFromSetShippingPackage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shippingPackageArrayShippingPackageItem) {
            // validation for constraint: itemType
            if (!$shippingPackageArrayShippingPackageItem instanceof \StructType\ShippingPackage) {
                $invalidValues[] = is_object($shippingPackageArrayShippingPackageItem) ? get_class($shippingPackageArrayShippingPackageItem) : sprintf('%s(%s)', gettype($shippingPackageArrayShippingPackageItem), var_export($shippingPackageArrayShippingPackageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShippingPackage property can only contain items of type \StructType\ShippingPackage, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShippingPackage value
     * @throws \InvalidArgumentException
     * @param \StructType\ShippingPackage[] $shippingPackage
     * @return \ArrayType\ShippingPackageArray
     */
    public function setShippingPackage(array $shippingPackage = array())
    {
        // validation for constraint: array
        if ('' !== ($shippingPackageArrayErrorMessage = self::validateShippingPackageForArrayConstraintsFromSetShippingPackage($shippingPackage))) {
            throw new \InvalidArgumentException($shippingPackageArrayErrorMessage, __LINE__);
        }
        $this->ShippingPackage = $shippingPackage;
        return $this;
    }
    /**
     * Add item to ShippingPackage value
     * @throws \InvalidArgumentException
     * @param \StructType\ShippingPackage $item
     * @return \ArrayType\ShippingPackageArray
     */
    public function addToShippingPackage(\StructType\ShippingPackage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShippingPackage) {
            throw new \InvalidArgumentException(sprintf('The ShippingPackage property can only contain items of type \StructType\ShippingPackage, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShippingPackage[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ShippingPackage|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ShippingPackage|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ShippingPackage|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ShippingPackage|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ShippingPackage|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ShippingPackage
     */
    public function getAttributeName()
    {
        return 'ShippingPackage';
    }
}
