<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for RelatedProductArray ArrayType
 * @subpackage Arrays
 */
class RelatedProductArray extends AbstractStructArrayBase
{
    /**
     * The RelatedProduct
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns3:RelatedProduct
     * @var \StructType\RelatedProduct[]
     */
    public $RelatedProduct;
    /**
     * Constructor method for RelatedProductArray
     * @uses RelatedProductArray::setRelatedProduct()
     * @param \StructType\RelatedProduct[] $relatedProduct
     */
    public function __construct(array $relatedProduct = array())
    {
        $this
            ->setRelatedProduct($relatedProduct);
    }
    /**
     * Get RelatedProduct value
     * @return \StructType\RelatedProduct[]|null
     */
    public function getRelatedProduct()
    {
        return $this->RelatedProduct;
    }
    /**
     * This method is responsible for validating the values passed to the setRelatedProduct method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelatedProduct method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelatedProductForArrayConstraintsFromSetRelatedProduct(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $relatedProductArrayRelatedProductItem) {
            // validation for constraint: itemType
            if (!$relatedProductArrayRelatedProductItem instanceof \StructType\RelatedProduct) {
                $invalidValues[] = is_object($relatedProductArrayRelatedProductItem) ? get_class($relatedProductArrayRelatedProductItem) : sprintf('%s(%s)', gettype($relatedProductArrayRelatedProductItem), var_export($relatedProductArrayRelatedProductItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RelatedProduct property can only contain items of type \StructType\RelatedProduct, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RelatedProduct value
     * @throws \InvalidArgumentException
     * @param \StructType\RelatedProduct[] $relatedProduct
     * @return \ArrayType\RelatedProductArray
     */
    public function setRelatedProduct(array $relatedProduct = array())
    {
        // validation for constraint: array
        if ('' !== ($relatedProductArrayErrorMessage = self::validateRelatedProductForArrayConstraintsFromSetRelatedProduct($relatedProduct))) {
            throw new \InvalidArgumentException($relatedProductArrayErrorMessage, __LINE__);
        }
        $this->RelatedProduct = $relatedProduct;
        return $this;
    }
    /**
     * Add item to RelatedProduct value
     * @throws \InvalidArgumentException
     * @param \StructType\RelatedProduct $item
     * @return \ArrayType\RelatedProductArray
     */
    public function addToRelatedProduct(\StructType\RelatedProduct $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RelatedProduct) {
            throw new \InvalidArgumentException(sprintf('The RelatedProduct property can only contain items of type \StructType\RelatedProduct, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RelatedProduct[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RelatedProduct|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RelatedProduct|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RelatedProduct|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RelatedProduct|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RelatedProduct|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RelatedProduct
     */
    public function getAttributeName()
    {
        return 'RelatedProduct';
    }
}
