<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ProductSellableArray ArrayType
 * @subpackage Arrays
 */
class ProductSellableArray extends AbstractStructArrayBase
{
    /**
     * The ProductSellable
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ProductSellable[]
     */
    public $ProductSellable;
    /**
     * Constructor method for ProductSellableArray
     * @uses ProductSellableArray::setProductSellable()
     * @param \StructType\ProductSellable[] $productSellable
     */
    public function __construct(array $productSellable = array())
    {
        $this
            ->setProductSellable($productSellable);
    }
    /**
     * Get ProductSellable value
     * @return \StructType\ProductSellable[]|null
     */
    public function getProductSellable()
    {
        return $this->ProductSellable;
    }
    /**
     * This method is responsible for validating the values passed to the setProductSellable method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductSellable method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductSellableForArrayConstraintsFromSetProductSellable(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productSellableArrayProductSellableItem) {
            // validation for constraint: itemType
            if (!$productSellableArrayProductSellableItem instanceof \StructType\ProductSellable) {
                $invalidValues[] = is_object($productSellableArrayProductSellableItem) ? get_class($productSellableArrayProductSellableItem) : sprintf('%s(%s)', gettype($productSellableArrayProductSellableItem), var_export($productSellableArrayProductSellableItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProductSellable property can only contain items of type \StructType\ProductSellable, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProductSellable value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductSellable[] $productSellable
     * @return \ArrayType\ProductSellableArray
     */
    public function setProductSellable(array $productSellable = array())
    {
        // validation for constraint: array
        if ('' !== ($productSellableArrayErrorMessage = self::validateProductSellableForArrayConstraintsFromSetProductSellable($productSellable))) {
            throw new \InvalidArgumentException($productSellableArrayErrorMessage, __LINE__);
        }
        $this->ProductSellable = $productSellable;
        return $this;
    }
    /**
     * Add item to ProductSellable value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductSellable $item
     * @return \ArrayType\ProductSellableArray
     */
    public function addToProductSellable(\StructType\ProductSellable $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductSellable) {
            throw new \InvalidArgumentException(sprintf('The ProductSellable property can only contain items of type \StructType\ProductSellable, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProductSellable[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductSellable|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductSellable|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductSellable|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductSellable|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductSellable|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductSellable
     */
    public function getAttributeName()
    {
        return 'ProductSellable';
    }
}
