<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ProductPriceGroupArray ArrayType
 * @subpackage Arrays
 */
class ProductPriceGroupArray extends AbstractStructArrayBase
{
    /**
     * The ProductPriceGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns3:ProductPriceGroup
     * @var \StructType\ProductPriceGroup[]
     */
    public $ProductPriceGroup;
    /**
     * Constructor method for ProductPriceGroupArray
     * @uses ProductPriceGroupArray::setProductPriceGroup()
     * @param \StructType\ProductPriceGroup[] $productPriceGroup
     */
    public function __construct(array $productPriceGroup = array())
    {
        $this
            ->setProductPriceGroup($productPriceGroup);
    }
    /**
     * Get ProductPriceGroup value
     * @return \StructType\ProductPriceGroup[]|null
     */
    public function getProductPriceGroup()
    {
        return $this->ProductPriceGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setProductPriceGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductPriceGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductPriceGroupForArrayConstraintsFromSetProductPriceGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productPriceGroupArrayProductPriceGroupItem) {
            // validation for constraint: itemType
            if (!$productPriceGroupArrayProductPriceGroupItem instanceof \StructType\ProductPriceGroup) {
                $invalidValues[] = is_object($productPriceGroupArrayProductPriceGroupItem) ? get_class($productPriceGroupArrayProductPriceGroupItem) : sprintf('%s(%s)', gettype($productPriceGroupArrayProductPriceGroupItem), var_export($productPriceGroupArrayProductPriceGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProductPriceGroup property can only contain items of type \StructType\ProductPriceGroup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProductPriceGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductPriceGroup[] $productPriceGroup
     * @return \ArrayType\ProductPriceGroupArray
     */
    public function setProductPriceGroup(array $productPriceGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($productPriceGroupArrayErrorMessage = self::validateProductPriceGroupForArrayConstraintsFromSetProductPriceGroup($productPriceGroup))) {
            throw new \InvalidArgumentException($productPriceGroupArrayErrorMessage, __LINE__);
        }
        $this->ProductPriceGroup = $productPriceGroup;
        return $this;
    }
    /**
     * Add item to ProductPriceGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductPriceGroup $item
     * @return \ArrayType\ProductPriceGroupArray
     */
    public function addToProductPriceGroup(\StructType\ProductPriceGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductPriceGroup) {
            throw new \InvalidArgumentException(sprintf('The ProductPriceGroup property can only contain items of type \StructType\ProductPriceGroup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProductPriceGroup[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductPriceGroup|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductPriceGroup|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductPriceGroup|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductPriceGroup|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductPriceGroup|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductPriceGroup
     */
    public function getAttributeName()
    {
        return 'ProductPriceGroup';
    }
}
