<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ProductPartArray ArrayType
 * @subpackage Arrays
 */
class ProductPartArray extends AbstractStructArrayBase
{
    /**
     * The ProductPart
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ProductPart[]
     */
    public $ProductPart;
    /**
     * Constructor method for ProductPartArray
     * @uses ProductPartArray::setProductPart()
     * @param \StructType\ProductPart[] $productPart
     */
    public function __construct(array $productPart = array())
    {
        $this
            ->setProductPart($productPart);
    }
    /**
     * Get ProductPart value
     * @return \StructType\ProductPart[]|null
     */
    public function getProductPart()
    {
        return $this->ProductPart;
    }
    /**
     * This method is responsible for validating the values passed to the setProductPart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductPart method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductPartForArrayConstraintsFromSetProductPart(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productPartArrayProductPartItem) {
            // validation for constraint: itemType
            if (!$productPartArrayProductPartItem instanceof \StructType\ProductPart) {
                $invalidValues[] = is_object($productPartArrayProductPartItem) ? get_class($productPartArrayProductPartItem) : sprintf('%s(%s)', gettype($productPartArrayProductPartItem), var_export($productPartArrayProductPartItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProductPart property can only contain items of type \StructType\ProductPart, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProductPart value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductPart[] $productPart
     * @return \ArrayType\ProductPartArray
     */
    public function setProductPart(array $productPart = array())
    {
        // validation for constraint: array
        if ('' !== ($productPartArrayErrorMessage = self::validateProductPartForArrayConstraintsFromSetProductPart($productPart))) {
            throw new \InvalidArgumentException($productPartArrayErrorMessage, __LINE__);
        }
        $this->ProductPart = $productPart;
        return $this;
    }
    /**
     * Add item to ProductPart value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductPart $item
     * @return \ArrayType\ProductPartArray
     */
    public function addToProductPart(\StructType\ProductPart $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductPart) {
            throw new \InvalidArgumentException(sprintf('The ProductPart property can only contain items of type \StructType\ProductPart, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProductPart[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductPart|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductPart|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductPart|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductPart|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductPart|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductPart
     */
    public function getAttributeName()
    {
        return 'ProductPart';
    }
}
