<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ProductMarketingPointArray ArrayType
 * @subpackage Arrays
 */
class ProductMarketingPointArray extends AbstractStructArrayBase
{
    /**
     * The ProductMarketingPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns3:ProductMarketingPoint
     * @var \StructType\ProductMarketingPoint[]
     */
    public $ProductMarketingPoint;
    /**
     * Constructor method for ProductMarketingPointArray
     * @uses ProductMarketingPointArray::setProductMarketingPoint()
     * @param \StructType\ProductMarketingPoint[] $productMarketingPoint
     */
    public function __construct(array $productMarketingPoint = array())
    {
        $this
            ->setProductMarketingPoint($productMarketingPoint);
    }
    /**
     * Get ProductMarketingPoint value
     * @return \StructType\ProductMarketingPoint[]|null
     */
    public function getProductMarketingPoint()
    {
        return $this->ProductMarketingPoint;
    }
    /**
     * This method is responsible for validating the values passed to the setProductMarketingPoint method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductMarketingPoint method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductMarketingPointForArrayConstraintsFromSetProductMarketingPoint(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productMarketingPointArrayProductMarketingPointItem) {
            // validation for constraint: itemType
            if (!$productMarketingPointArrayProductMarketingPointItem instanceof \StructType\ProductMarketingPoint) {
                $invalidValues[] = is_object($productMarketingPointArrayProductMarketingPointItem) ? get_class($productMarketingPointArrayProductMarketingPointItem) : sprintf('%s(%s)', gettype($productMarketingPointArrayProductMarketingPointItem), var_export($productMarketingPointArrayProductMarketingPointItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProductMarketingPoint property can only contain items of type \StructType\ProductMarketingPoint, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProductMarketingPoint value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductMarketingPoint[] $productMarketingPoint
     * @return \ArrayType\ProductMarketingPointArray
     */
    public function setProductMarketingPoint(array $productMarketingPoint = array())
    {
        // validation for constraint: array
        if ('' !== ($productMarketingPointArrayErrorMessage = self::validateProductMarketingPointForArrayConstraintsFromSetProductMarketingPoint($productMarketingPoint))) {
            throw new \InvalidArgumentException($productMarketingPointArrayErrorMessage, __LINE__);
        }
        $this->ProductMarketingPoint = $productMarketingPoint;
        return $this;
    }
    /**
     * Add item to ProductMarketingPoint value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductMarketingPoint $item
     * @return \ArrayType\ProductMarketingPointArray
     */
    public function addToProductMarketingPoint(\StructType\ProductMarketingPoint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductMarketingPoint) {
            throw new \InvalidArgumentException(sprintf('The ProductMarketingPoint property can only contain items of type \StructType\ProductMarketingPoint, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProductMarketingPoint[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductMarketingPoint|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductMarketingPoint|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductMarketingPoint|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductMarketingPoint|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductMarketingPoint|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductMarketingPoint
     */
    public function getAttributeName()
    {
        return 'ProductMarketingPoint';
    }
}
