<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ProductKeywordArray ArrayType
 * @subpackage Arrays
 */
class ProductKeywordArray extends AbstractStructArrayBase
{
    /**
     * The ProductKeyword
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns3:ProductKeyword
     * @var \StructType\ProductKeyword[]
     */
    public $ProductKeyword;
    /**
     * Constructor method for ProductKeywordArray
     * @uses ProductKeywordArray::setProductKeyword()
     * @param \StructType\ProductKeyword[] $productKeyword
     */
    public function __construct(array $productKeyword = array())
    {
        $this
            ->setProductKeyword($productKeyword);
    }
    /**
     * Get ProductKeyword value
     * @return \StructType\ProductKeyword[]|null
     */
    public function getProductKeyword()
    {
        return $this->ProductKeyword;
    }
    /**
     * This method is responsible for validating the values passed to the setProductKeyword method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductKeyword method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductKeywordForArrayConstraintsFromSetProductKeyword(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productKeywordArrayProductKeywordItem) {
            // validation for constraint: itemType
            if (!$productKeywordArrayProductKeywordItem instanceof \StructType\ProductKeyword) {
                $invalidValues[] = is_object($productKeywordArrayProductKeywordItem) ? get_class($productKeywordArrayProductKeywordItem) : sprintf('%s(%s)', gettype($productKeywordArrayProductKeywordItem), var_export($productKeywordArrayProductKeywordItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProductKeyword property can only contain items of type \StructType\ProductKeyword, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProductKeyword value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductKeyword[] $productKeyword
     * @return \ArrayType\ProductKeywordArray
     */
    public function setProductKeyword(array $productKeyword = array())
    {
        // validation for constraint: array
        if ('' !== ($productKeywordArrayErrorMessage = self::validateProductKeywordForArrayConstraintsFromSetProductKeyword($productKeyword))) {
            throw new \InvalidArgumentException($productKeywordArrayErrorMessage, __LINE__);
        }
        $this->ProductKeyword = $productKeyword;
        return $this;
    }
    /**
     * Add item to ProductKeyword value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductKeyword $item
     * @return \ArrayType\ProductKeywordArray
     */
    public function addToProductKeyword(\StructType\ProductKeyword $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductKeyword) {
            throw new \InvalidArgumentException(sprintf('The ProductKeyword property can only contain items of type \StructType\ProductKeyword, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProductKeyword[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductKeyword|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductKeyword|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductKeyword|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductKeyword|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductKeyword|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductKeyword
     */
    public function getAttributeName()
    {
        return 'ProductKeyword';
    }
}
