<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ProductCloseOutArray ArrayType
 * @subpackage Arrays
 */
class ProductCloseOutArray extends AbstractStructArrayBase
{
    /**
     * The ProductCloseOut
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns1:ProductCloseOut
     * @var \StructType\ProductCloseOut[]
     */
    public $ProductCloseOut;
    /**
     * Constructor method for ProductCloseOutArray
     * @uses ProductCloseOutArray::setProductCloseOut()
     * @param \StructType\ProductCloseOut[] $productCloseOut
     */
    public function __construct(array $productCloseOut = array())
    {
        $this
            ->setProductCloseOut($productCloseOut);
    }
    /**
     * Get ProductCloseOut value
     * @return \StructType\ProductCloseOut[]|null
     */
    public function getProductCloseOut()
    {
        return $this->ProductCloseOut;
    }
    /**
     * This method is responsible for validating the values passed to the setProductCloseOut method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductCloseOut method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductCloseOutForArrayConstraintsFromSetProductCloseOut(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productCloseOutArrayProductCloseOutItem) {
            // validation for constraint: itemType
            if (!$productCloseOutArrayProductCloseOutItem instanceof \StructType\ProductCloseOut) {
                $invalidValues[] = is_object($productCloseOutArrayProductCloseOutItem) ? get_class($productCloseOutArrayProductCloseOutItem) : sprintf('%s(%s)', gettype($productCloseOutArrayProductCloseOutItem), var_export($productCloseOutArrayProductCloseOutItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProductCloseOut property can only contain items of type \StructType\ProductCloseOut, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProductCloseOut value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductCloseOut[] $productCloseOut
     * @return \ArrayType\ProductCloseOutArray
     */
    public function setProductCloseOut(array $productCloseOut = array())
    {
        // validation for constraint: array
        if ('' !== ($productCloseOutArrayErrorMessage = self::validateProductCloseOutForArrayConstraintsFromSetProductCloseOut($productCloseOut))) {
            throw new \InvalidArgumentException($productCloseOutArrayErrorMessage, __LINE__);
        }
        $this->ProductCloseOut = $productCloseOut;
        return $this;
    }
    /**
     * Add item to ProductCloseOut value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductCloseOut $item
     * @return \ArrayType\ProductCloseOutArray
     */
    public function addToProductCloseOut(\StructType\ProductCloseOut $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductCloseOut) {
            throw new \InvalidArgumentException(sprintf('The ProductCloseOut property can only contain items of type \StructType\ProductCloseOut, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProductCloseOut[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductCloseOut|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductCloseOut|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductCloseOut|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductCloseOut|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductCloseOut|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductCloseOut
     */
    public function getAttributeName()
    {
        return 'ProductCloseOut';
    }
}
