<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for LocationDecorationArray ArrayType
 * @subpackage Arrays
 */
class LocationDecorationArray extends AbstractStructArrayBase
{
    /**
     * The LocationDecoration
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\LocationDecoration[]
     */
    public $LocationDecoration;
    /**
     * Constructor method for LocationDecorationArray
     * @uses LocationDecorationArray::setLocationDecoration()
     * @param \StructType\LocationDecoration[] $locationDecoration
     */
    public function __construct(array $locationDecoration = array())
    {
        $this
            ->setLocationDecoration($locationDecoration);
    }
    /**
     * Get LocationDecoration value
     * @return \StructType\LocationDecoration[]|null
     */
    public function getLocationDecoration()
    {
        return $this->LocationDecoration;
    }
    /**
     * This method is responsible for validating the values passed to the setLocationDecoration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocationDecoration method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationDecorationForArrayConstraintsFromSetLocationDecoration(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationDecorationArrayLocationDecorationItem) {
            // validation for constraint: itemType
            if (!$locationDecorationArrayLocationDecorationItem instanceof \StructType\LocationDecoration) {
                $invalidValues[] = is_object($locationDecorationArrayLocationDecorationItem) ? get_class($locationDecorationArrayLocationDecorationItem) : sprintf('%s(%s)', gettype($locationDecorationArrayLocationDecorationItem), var_export($locationDecorationArrayLocationDecorationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LocationDecoration property can only contain items of type \StructType\LocationDecoration, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LocationDecoration value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationDecoration[] $locationDecoration
     * @return \ArrayType\LocationDecorationArray
     */
    public function setLocationDecoration(array $locationDecoration = array())
    {
        // validation for constraint: array
        if ('' !== ($locationDecorationArrayErrorMessage = self::validateLocationDecorationForArrayConstraintsFromSetLocationDecoration($locationDecoration))) {
            throw new \InvalidArgumentException($locationDecorationArrayErrorMessage, __LINE__);
        }
        $this->LocationDecoration = $locationDecoration;
        return $this;
    }
    /**
     * Add item to LocationDecoration value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationDecoration $item
     * @return \ArrayType\LocationDecorationArray
     */
    public function addToLocationDecoration(\StructType\LocationDecoration $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LocationDecoration) {
            throw new \InvalidArgumentException(sprintf('The LocationDecoration property can only contain items of type \StructType\LocationDecoration, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LocationDecoration[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\LocationDecoration|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\LocationDecoration|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\LocationDecoration|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\LocationDecoration|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\LocationDecoration|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LocationDecoration
     */
    public function getAttributeName()
    {
        return 'LocationDecoration';
    }
}
