<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ImprintColorsArray ArrayType
 * @subpackage Arrays
 */
class ImprintColorsArray extends AbstractStructArrayBase
{
    /**
     * The Color
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Color;
    /**
     * Constructor method for ImprintColorsArray
     * @uses ImprintColorsArray::setColor()
     * @param mixed[] $color
     */
    public function __construct(array $color = array())
    {
        $this
            ->setColor($color);
    }
    /**
     * Get Color value
     * @return mixed[]|null
     */
    public function getColor()
    {
        return $this->Color;
    }
    /**
     * This method is responsible for validating the values passed to the setColor method
     * This method is willingly generated in order to preserve the one-line inline validation within the setColor method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateColorForArrayConstraintsFromSetColor(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $imprintColorsArrayColorItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($imprintColorsArrayColorItem) ? get_class($imprintColorsArrayColorItem) : sprintf('%s(%s)', gettype($imprintColorsArrayColorItem), var_export($imprintColorsArrayColorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Color property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Color value
     * @throws \InvalidArgumentException
     * @param mixed[] $color
     * @return \ArrayType\ImprintColorsArray
     */
    public function setColor(array $color = array())
    {
        // validation for constraint: array
        if ('' !== ($colorArrayErrorMessage = self::validateColorForArrayConstraintsFromSetColor($color))) {
            throw new \InvalidArgumentException($colorArrayErrorMessage, __LINE__);
        }
        $this->Color = $color;
        return $this;
    }
    /**
     * Add item to Color value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \ArrayType\ImprintColorsArray
     */
    public function addToColor($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Color property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Color[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return mixed|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return mixed|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return mixed|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return mixed|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return mixed|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Color
     */
    public function getAttributeName()
    {
        return 'Color';
    }
}
