<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for FobPointArray ArrayType
 * @subpackage Arrays
 */
class FobPointArray extends AbstractStructArrayBase
{
    /**
     * The FobPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns2:FobPoint
     * @var \StructType\FobPoint[]
     */
    public $FobPoint;
    /**
     * Constructor method for FobPointArray
     * @uses FobPointArray::setFobPoint()
     * @param \StructType\FobPoint[] $fobPoint
     */
    public function __construct(array $fobPoint = array())
    {
        $this
            ->setFobPoint($fobPoint);
    }
    /**
     * Get FobPoint value
     * @return \StructType\FobPoint[]|null
     */
    public function getFobPoint()
    {
        return $this->FobPoint;
    }
    /**
     * This method is responsible for validating the values passed to the setFobPoint method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFobPoint method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFobPointForArrayConstraintsFromSetFobPoint(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fobPointArrayFobPointItem) {
            // validation for constraint: itemType
            if (!$fobPointArrayFobPointItem instanceof \StructType\FobPoint) {
                $invalidValues[] = is_object($fobPointArrayFobPointItem) ? get_class($fobPointArrayFobPointItem) : sprintf('%s(%s)', gettype($fobPointArrayFobPointItem), var_export($fobPointArrayFobPointItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FobPoint property can only contain items of type \StructType\FobPoint, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FobPoint value
     * @throws \InvalidArgumentException
     * @param \StructType\FobPoint[] $fobPoint
     * @return \ArrayType\FobPointArray
     */
    public function setFobPoint(array $fobPoint = array())
    {
        // validation for constraint: array
        if ('' !== ($fobPointArrayErrorMessage = self::validateFobPointForArrayConstraintsFromSetFobPoint($fobPoint))) {
            throw new \InvalidArgumentException($fobPointArrayErrorMessage, __LINE__);
        }
        $this->FobPoint = $fobPoint;
        return $this;
    }
    /**
     * Add item to FobPoint value
     * @throws \InvalidArgumentException
     * @param \StructType\FobPoint $item
     * @return \ArrayType\FobPointArray
     */
    public function addToFobPoint(\StructType\FobPoint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FobPoint) {
            throw new \InvalidArgumentException(sprintf('The FobPoint property can only contain items of type \StructType\FobPoint, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FobPoint[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\FobPoint|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\FobPoint|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\FobPoint|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\FobPoint|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\FobPoint|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FobPoint
     */
    public function getAttributeName()
    {
        return 'FobPoint';
    }
}
