<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ApparelSizeArray ArrayType
 * @subpackage Arrays
 */
class ApparelSizeArray extends AbstractStructArrayBase
{
    /**
     * The ApparelSize
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns2:ApparelSize
     * @var \StructType\ApparelSize[]
     */
    public $ApparelSize;
    /**
     * Constructor method for ApparelSizeArray
     * @uses ApparelSizeArray::setApparelSize()
     * @param \StructType\ApparelSize[] $apparelSize
     */
    public function __construct(array $apparelSize = array())
    {
        $this
            ->setApparelSize($apparelSize);
    }
    /**
     * Get ApparelSize value
     * @return \StructType\ApparelSize[]|null
     */
    public function getApparelSize()
    {
        return $this->ApparelSize;
    }
    /**
     * This method is responsible for validating the values passed to the setApparelSize method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApparelSize method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApparelSizeForArrayConstraintsFromSetApparelSize(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $apparelSizeArrayApparelSizeItem) {
            // validation for constraint: itemType
            if (!$apparelSizeArrayApparelSizeItem instanceof \StructType\ApparelSize) {
                $invalidValues[] = is_object($apparelSizeArrayApparelSizeItem) ? get_class($apparelSizeArrayApparelSizeItem) : sprintf('%s(%s)', gettype($apparelSizeArrayApparelSizeItem), var_export($apparelSizeArrayApparelSizeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ApparelSize property can only contain items of type \StructType\ApparelSize, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ApparelSize value
     * @throws \InvalidArgumentException
     * @param \StructType\ApparelSize[] $apparelSize
     * @return \ArrayType\ApparelSizeArray
     */
    public function setApparelSize(array $apparelSize = array())
    {
        // validation for constraint: array
        if ('' !== ($apparelSizeArrayErrorMessage = self::validateApparelSizeForArrayConstraintsFromSetApparelSize($apparelSize))) {
            throw new \InvalidArgumentException($apparelSizeArrayErrorMessage, __LINE__);
        }
        $this->ApparelSize = $apparelSize;
        return $this;
    }
    /**
     * Add item to ApparelSize value
     * @throws \InvalidArgumentException
     * @param \StructType\ApparelSize $item
     * @return \ArrayType\ApparelSizeArray
     */
    public function addToApparelSize(\StructType\ApparelSize $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ApparelSize) {
            throw new \InvalidArgumentException(sprintf('The ApparelSize property can only contain items of type \StructType\ApparelSize, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ApparelSize[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ApparelSize|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ApparelSize|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ApparelSize|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ApparelSize|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ApparelSize|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ApparelSize
     */
    public function getAttributeName()
    {
        return 'ApparelSize';
    }
}
