<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceMessage StructType
 * @subpackage Structs
 */
class ServiceMessage extends AbstractStructBase
{
    /**
     * The code
     * @var int
     */
    public $code;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 256
     * - minLength: 1
     * @var string
     */
    public $description;
    /**
     * The severity
     * Meta information extracted from the WSDL
     * - base: ns2:SeverityType
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $severity;
    /**
     * Constructor method for ServiceMessage
     * @uses ServiceMessage::setCode()
     * @uses ServiceMessage::setDescription()
     * @uses ServiceMessage::setSeverity()
     * @param int $code
     * @param string $description
     * @param string $severity
     */
    public function __construct($code = null, $description = null, $severity = null)
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setSeverity($severity);
    }
    /**
     * Get code value
     * @return int|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param int $code
     * @return \StructType\ServiceMessage
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ServiceMessage
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($description) && mb_strlen($description) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($description)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($description) && mb_strlen($description) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get severity value
     * @return string|null
     */
    public function getSeverity()
    {
        return $this->severity;
    }
    /**
     * Set severity value
     * @param string $severity
     * @return \StructType\ServiceMessage
     */
    public function setSeverity($severity = null)
    {
        // validation for constraint: string
        if (!is_null($severity) && !is_string($severity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($severity, true), gettype($severity)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($severity) && mb_strlen($severity) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($severity)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($severity) && mb_strlen($severity) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($severity)), __LINE__);
        }
        $this->severity = $severity;
        return $this;
    }
}
