<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatedProduct StructType
 * @subpackage Structs
 */
class RelatedProduct extends AbstractStructBase
{
    /**
     * The relationType
     * Meta information extracted from the WSDL
     * - base: ns2:relationTypeEnum
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $relationType;
    /**
     * The productId
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - ref: ns2:productId
     * @var string
     */
    public $productId;
    /**
     * The partId
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns2:partId
     * @var string
     */
    public $partId;
    /**
     * Constructor method for RelatedProduct
     * @uses RelatedProduct::setRelationType()
     * @uses RelatedProduct::setProductId()
     * @uses RelatedProduct::setPartId()
     * @param string $relationType
     * @param string $productId
     * @param string $partId
     */
    public function __construct($relationType = null, $productId = null, $partId = null)
    {
        $this
            ->setRelationType($relationType)
            ->setProductId($productId)
            ->setPartId($partId);
    }
    /**
     * Get relationType value
     * @return string|null
     */
    public function getRelationType()
    {
        return $this->relationType;
    }
    /**
     * Set relationType value
     * @param string $relationType
     * @return \StructType\RelatedProduct
     */
    public function setRelationType($relationType = null)
    {
        // validation for constraint: string
        if (!is_null($relationType) && !is_string($relationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationType, true), gettype($relationType)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($relationType) && mb_strlen($relationType) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($relationType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($relationType) && mb_strlen($relationType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($relationType)), __LINE__);
        }
        $this->relationType = $relationType;
        return $this;
    }
    /**
     * Get productId value
     * @return string|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param string $productId
     * @return \StructType\RelatedProduct
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($productId) && mb_strlen($productId) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($productId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($productId) && mb_strlen($productId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get partId value
     * @return string|null
     */
    public function getPartId()
    {
        return $this->partId;
    }
    /**
     * Set partId value
     * @param string $partId
     * @return \StructType\RelatedProduct
     */
    public function setPartId($partId = null)
    {
        // validation for constraint: string
        if (!is_null($partId) && !is_string($partId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partId, true), gettype($partId)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($partId) && mb_strlen($partId) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($partId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($partId) && mb_strlen($partId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($partId)), __LINE__);
        }
        $this->partId = $partId;
        return $this;
    }
}
