<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductPrice StructType
 * @subpackage Structs
 */
class ProductPrice extends AbstractStructBase
{
    /**
     * The quantityMin
     * @var int
     */
    public $quantityMin;
    /**
     * The quantityMax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $quantityMax;
    /**
     * The price
     * @var float
     */
    public $price;
    /**
     * The discountCode
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 5
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $discountCode;
    /**
     * Constructor method for ProductPrice
     * @uses ProductPrice::setQuantityMin()
     * @uses ProductPrice::setQuantityMax()
     * @uses ProductPrice::setPrice()
     * @uses ProductPrice::setDiscountCode()
     * @param int $quantityMin
     * @param int $quantityMax
     * @param float $price
     * @param string $discountCode
     */
    public function __construct($quantityMin = null, $quantityMax = null, $price = null, $discountCode = null)
    {
        $this
            ->setQuantityMin($quantityMin)
            ->setQuantityMax($quantityMax)
            ->setPrice($price)
            ->setDiscountCode($discountCode);
    }
    /**
     * Get quantityMin value
     * @return int|null
     */
    public function getQuantityMin()
    {
        return $this->quantityMin;
    }
    /**
     * Set quantityMin value
     * @param int $quantityMin
     * @return \StructType\ProductPrice
     */
    public function setQuantityMin($quantityMin = null)
    {
        // validation for constraint: int
        if (!is_null($quantityMin) && !(is_int($quantityMin) || ctype_digit($quantityMin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityMin, true), gettype($quantityMin)), __LINE__);
        }
        $this->quantityMin = $quantityMin;
        return $this;
    }
    /**
     * Get quantityMax value
     * @return int|null
     */
    public function getQuantityMax()
    {
        return $this->quantityMax;
    }
    /**
     * Set quantityMax value
     * @param int $quantityMax
     * @return \StructType\ProductPrice
     */
    public function setQuantityMax($quantityMax = null)
    {
        // validation for constraint: int
        if (!is_null($quantityMax) && !(is_int($quantityMax) || ctype_digit($quantityMax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityMax, true), gettype($quantityMax)), __LINE__);
        }
        $this->quantityMax = $quantityMax;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\ProductPrice
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get discountCode value
     * @return string|null
     */
    public function getDiscountCode()
    {
        return $this->discountCode;
    }
    /**
     * Set discountCode value
     * @param string $discountCode
     * @return \StructType\ProductPrice
     */
    public function setDiscountCode($discountCode = null)
    {
        // validation for constraint: string
        if (!is_null($discountCode) && !is_string($discountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountCode, true), gettype($discountCode)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($discountCode) && mb_strlen($discountCode) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($discountCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($discountCode) && mb_strlen($discountCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($discountCode)), __LINE__);
        }
        $this->discountCode = $discountCode;
        return $this;
    }
}
