<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductPart StructType
 * @subpackage Structs
 */
class ProductPart extends AbstractStructBase
{
    /**
     * The partId
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - ref: ns3:partId
     * @var string
     */
    public $partId;
    /**
     * The primaryColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PrimaryColor
     */
    public $primaryColor;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 2048
     * - maxOccurs: unbounded
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns3:description
     * @var string[]
     */
    public $description;
    /**
     * The countryOfOrigin
     * Meta information extracted from the WSDL
     * - base: ns3:ISO3166CountyCode
     * - maxLength: 2
     * - minLength: 2
     * - minOccurs: 0
     * - ref: ns3:countryOfOrigin
     * @var string
     */
    public $countryOfOrigin;
    /**
     * The ColorArray
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ColorArray
     */
    public $ColorArray;
    /**
     * The primaryMaterial
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns3:primaryMaterial
     * @var string
     */
    public $primaryMaterial;
    /**
     * The SpecificationArray
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\SpecificationArray
     */
    public $SpecificationArray;
    /**
     * The shape
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns3:shape
     * @var string
     */
    public $shape;
    /**
     * The ApparelSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns3:ApparelSize
     * @var \StructType\ApparelSize
     */
    public $ApparelSize;
    /**
     * The Dimension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns3:Dimension
     * @var \StructType\Dimension
     */
    public $Dimension;
    /**
     * The leadTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $leadTime;
    /**
     * The unspsc
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 8
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns3:unspsc
     * @var string
     */
    public $unspsc;
    /**
     * The gtin
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 14
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns3:gtin
     * @var string
     */
    public $gtin;
    /**
     * The isRushService
     * Meta information extracted from the WSDL
     * - ref: ns3:isRushService
     * @var bool
     */
    public $isRushService;
    /**
     * The ProductPackagingArray
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ProductPackagingArray
     */
    public $ProductPackagingArray;
    /**
     * The ShippingPackageArray
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ShippingPackageArray
     */
    public $ShippingPackageArray;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - ref: ns3:endDate
     * @var string
     */
    public $endDate;
    /**
     * The effectiveDate
     * Meta information extracted from the WSDL
     * - ref: ns3:effectiveDate
     * @var string
     */
    public $effectiveDate;
    /**
     * The isCloseout
     * Meta information extracted from the WSDL
     * - ref: ns3:isCloseout
     * @var bool
     */
    public $isCloseout;
    /**
     * The isCaution
     * Meta information extracted from the WSDL
     * - ref: ns3:isCaution
     * @var bool
     */
    public $isCaution;
    /**
     * The cautionComment
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 1024
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns3:cautionComment
     * @var string
     */
    public $cautionComment;
    /**
     * The nmfcCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns3:nmfcCode
     * @var float
     */
    public $nmfcCode;
    /**
     * The nmfcDescription
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 1024
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns3:nmfcDescription
     * @var string
     */
    public $nmfcDescription;
    /**
     * The nmfcNumber
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns3:nmfcNumber
     * @var string
     */
    public $nmfcNumber;
    /**
     * The isOnDemand
     * Meta information extracted from the WSDL
     * - ref: ns3:isOnDemand
     * @var bool
     */
    public $isOnDemand;
    /**
     * The isHazmat
     * Meta information extracted from the WSDL
     * - ref: ns3:isHazmat
     * @var bool
     */
    public $isHazmat;
    /**
     * Constructor method for ProductPart
     * @uses ProductPart::setPartId()
     * @uses ProductPart::setPrimaryColor()
     * @uses ProductPart::setDescription()
     * @uses ProductPart::setCountryOfOrigin()
     * @uses ProductPart::setColorArray()
     * @uses ProductPart::setPrimaryMaterial()
     * @uses ProductPart::setSpecificationArray()
     * @uses ProductPart::setShape()
     * @uses ProductPart::setApparelSize()
     * @uses ProductPart::setDimension()
     * @uses ProductPart::setLeadTime()
     * @uses ProductPart::setUnspsc()
     * @uses ProductPart::setGtin()
     * @uses ProductPart::setIsRushService()
     * @uses ProductPart::setProductPackagingArray()
     * @uses ProductPart::setShippingPackageArray()
     * @uses ProductPart::setEndDate()
     * @uses ProductPart::setEffectiveDate()
     * @uses ProductPart::setIsCloseout()
     * @uses ProductPart::setIsCaution()
     * @uses ProductPart::setCautionComment()
     * @uses ProductPart::setNmfcCode()
     * @uses ProductPart::setNmfcDescription()
     * @uses ProductPart::setNmfcNumber()
     * @uses ProductPart::setIsOnDemand()
     * @uses ProductPart::setIsHazmat()
     * @param string $partId
     * @param \StructType\PrimaryColor $primaryColor
     * @param string[] $description
     * @param string $countryOfOrigin
     * @param \ArrayType\ColorArray $colorArray
     * @param string $primaryMaterial
     * @param \ArrayType\SpecificationArray $specificationArray
     * @param string $shape
     * @param \StructType\ApparelSize $apparelSize
     * @param \StructType\Dimension $dimension
     * @param int $leadTime
     * @param string $unspsc
     * @param string $gtin
     * @param bool $isRushService
     * @param \ArrayType\ProductPackagingArray $productPackagingArray
     * @param \ArrayType\ShippingPackageArray $shippingPackageArray
     * @param string $endDate
     * @param string $effectiveDate
     * @param bool $isCloseout
     * @param bool $isCaution
     * @param string $cautionComment
     * @param float $nmfcCode
     * @param string $nmfcDescription
     * @param string $nmfcNumber
     * @param bool $isOnDemand
     * @param bool $isHazmat
     */
    public function __construct($partId = null, \StructType\PrimaryColor $primaryColor = null, array $description = array(), $countryOfOrigin = null, \ArrayType\ColorArray $colorArray = null, $primaryMaterial = null, \ArrayType\SpecificationArray $specificationArray = null, $shape = null, \StructType\ApparelSize $apparelSize = null, \StructType\Dimension $dimension = null, $leadTime = null, $unspsc = null, $gtin = null, $isRushService = null, \ArrayType\ProductPackagingArray $productPackagingArray = null, \ArrayType\ShippingPackageArray $shippingPackageArray = null, $endDate = null, $effectiveDate = null, $isCloseout = null, $isCaution = null, $cautionComment = null, $nmfcCode = null, $nmfcDescription = null, $nmfcNumber = null, $isOnDemand = null, $isHazmat = null)
    {
        $this
            ->setPartId($partId)
            ->setPrimaryColor($primaryColor)
            ->setDescription($description)
            ->setCountryOfOrigin($countryOfOrigin)
            ->setColorArray($colorArray)
            ->setPrimaryMaterial($primaryMaterial)
            ->setSpecificationArray($specificationArray)
            ->setShape($shape)
            ->setApparelSize($apparelSize)
            ->setDimension($dimension)
            ->setLeadTime($leadTime)
            ->setUnspsc($unspsc)
            ->setGtin($gtin)
            ->setIsRushService($isRushService)
            ->setProductPackagingArray($productPackagingArray)
            ->setShippingPackageArray($shippingPackageArray)
            ->setEndDate($endDate)
            ->setEffectiveDate($effectiveDate)
            ->setIsCloseout($isCloseout)
            ->setIsCaution($isCaution)
            ->setCautionComment($cautionComment)
            ->setNmfcCode($nmfcCode)
            ->setNmfcDescription($nmfcDescription)
            ->setNmfcNumber($nmfcNumber)
            ->setIsOnDemand($isOnDemand)
            ->setIsHazmat($isHazmat);
    }
    /**
     * Get partId value
     * @return string|null
     */
    public function getPartId()
    {
        return $this->partId;
    }
    /**
     * Set partId value
     * @param string $partId
     * @return \StructType\ProductPart
     */
    public function setPartId($partId = null)
    {
        // validation for constraint: string
        if (!is_null($partId) && !is_string($partId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partId, true), gettype($partId)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($partId) && mb_strlen($partId) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($partId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($partId) && mb_strlen($partId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($partId)), __LINE__);
        }
        $this->partId = $partId;
        return $this;
    }
    /**
     * Get primaryColor value
     * @return \StructType\PrimaryColor|null
     */
    public function getPrimaryColor()
    {
        return $this->primaryColor;
    }
    /**
     * Set primaryColor value
     * @param \StructType\PrimaryColor $primaryColor
     * @return \StructType\ProductPart
     */
    public function setPrimaryColor(\StructType\PrimaryColor $primaryColor = null)
    {
        $this->primaryColor = $primaryColor;
        return $this;
    }
    /**
     * Get description value
     * @return string[]|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productPartDescriptionItem) {
            // validation for constraint: itemType
            if (!is_string($productPartDescriptionItem)) {
                $invalidValues[] = is_object($productPartDescriptionItem) ? get_class($productPartDescriptionItem) : sprintf('%s(%s)', gettype($productPartDescriptionItem), var_export($productPartDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The description property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForMaxLengthConstraintFromSetDescription($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productPartDescriptionItem) {
            // validation for constraint: maxLength(2048)
            if (mb_strlen($productPartDescriptionItem) > 2048) {
                $invalidValues[] = var_export($productPartDescriptionItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 2048', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForMinLengthConstraintFromSetDescription($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productPartDescriptionItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($productPartDescriptionItem) < 1) {
                $invalidValues[] = var_export($productPartDescriptionItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set description value
     * @throws \InvalidArgumentException
     * @param string[] $description
     * @return \StructType\ProductPart
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(2048)
        if ('' !== ($descriptionMaxLengthErrorMessage = self::validateDescriptionForMaxLengthConstraintFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($descriptionMinLengthErrorMessage = self::validateDescriptionForMinLengthConstraintFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionMinLengthErrorMessage, __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Add item to description value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ProductPart
     */
    public function addToDescription($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The description property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(2048)
        if (mb_strlen($item) > 2048) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2048', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        $this->description[] = $item;
        return $this;
    }
    /**
     * Get countryOfOrigin value
     * @return string|null
     */
    public function getCountryOfOrigin()
    {
        return $this->countryOfOrigin;
    }
    /**
     * Set countryOfOrigin value
     * @param string $countryOfOrigin
     * @return \StructType\ProductPart
     */
    public function setCountryOfOrigin($countryOfOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfOrigin) && !is_string($countryOfOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryOfOrigin, true), gettype($countryOfOrigin)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($countryOfOrigin) && mb_strlen($countryOfOrigin) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($countryOfOrigin)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($countryOfOrigin) && mb_strlen($countryOfOrigin) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($countryOfOrigin)), __LINE__);
        }
        $this->countryOfOrigin = $countryOfOrigin;
        return $this;
    }
    /**
     * Get ColorArray value
     * @return \ArrayType\ColorArray|null
     */
    public function getColorArray()
    {
        return $this->ColorArray;
    }
    /**
     * Set ColorArray value
     * @param \ArrayType\ColorArray $colorArray
     * @return \StructType\ProductPart
     */
    public function setColorArray(\ArrayType\ColorArray $colorArray = null)
    {
        $this->ColorArray = $colorArray;
        return $this;
    }
    /**
     * Get primaryMaterial value
     * @return string|null
     */
    public function getPrimaryMaterial()
    {
        return $this->primaryMaterial;
    }
    /**
     * Set primaryMaterial value
     * @param string $primaryMaterial
     * @return \StructType\ProductPart
     */
    public function setPrimaryMaterial($primaryMaterial = null)
    {
        // validation for constraint: string
        if (!is_null($primaryMaterial) && !is_string($primaryMaterial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryMaterial, true), gettype($primaryMaterial)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($primaryMaterial) && mb_strlen($primaryMaterial) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($primaryMaterial)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($primaryMaterial) && mb_strlen($primaryMaterial) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($primaryMaterial)), __LINE__);
        }
        $this->primaryMaterial = $primaryMaterial;
        return $this;
    }
    /**
     * Get SpecificationArray value
     * @return \ArrayType\SpecificationArray|null
     */
    public function getSpecificationArray()
    {
        return $this->SpecificationArray;
    }
    /**
     * Set SpecificationArray value
     * @param \ArrayType\SpecificationArray $specificationArray
     * @return \StructType\ProductPart
     */
    public function setSpecificationArray(\ArrayType\SpecificationArray $specificationArray = null)
    {
        $this->SpecificationArray = $specificationArray;
        return $this;
    }
    /**
     * Get shape value
     * @return string|null
     */
    public function getShape()
    {
        return $this->shape;
    }
    /**
     * Set shape value
     * @param string $shape
     * @return \StructType\ProductPart
     */
    public function setShape($shape = null)
    {
        // validation for constraint: string
        if (!is_null($shape) && !is_string($shape)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shape, true), gettype($shape)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($shape) && mb_strlen($shape) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($shape)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($shape) && mb_strlen($shape) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($shape)), __LINE__);
        }
        $this->shape = $shape;
        return $this;
    }
    /**
     * Get ApparelSize value
     * @return \StructType\ApparelSize|null
     */
    public function getApparelSize()
    {
        return $this->ApparelSize;
    }
    /**
     * Set ApparelSize value
     * @param \StructType\ApparelSize $apparelSize
     * @return \StructType\ProductPart
     */
    public function setApparelSize(\StructType\ApparelSize $apparelSize = null)
    {
        $this->ApparelSize = $apparelSize;
        return $this;
    }
    /**
     * Get Dimension value
     * @return \StructType\Dimension|null
     */
    public function getDimension()
    {
        return $this->Dimension;
    }
    /**
     * Set Dimension value
     * @param \StructType\Dimension $dimension
     * @return \StructType\ProductPart
     */
    public function setDimension(\StructType\Dimension $dimension = null)
    {
        $this->Dimension = $dimension;
        return $this;
    }
    /**
     * Get leadTime value
     * @return int|null
     */
    public function getLeadTime()
    {
        return $this->leadTime;
    }
    /**
     * Set leadTime value
     * @param int $leadTime
     * @return \StructType\ProductPart
     */
    public function setLeadTime($leadTime = null)
    {
        // validation for constraint: int
        if (!is_null($leadTime) && !(is_int($leadTime) || ctype_digit($leadTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($leadTime, true), gettype($leadTime)), __LINE__);
        }
        $this->leadTime = $leadTime;
        return $this;
    }
    /**
     * Get unspsc value
     * @return string|null
     */
    public function getUnspsc()
    {
        return $this->unspsc;
    }
    /**
     * Set unspsc value
     * @param string $unspsc
     * @return \StructType\ProductPart
     */
    public function setUnspsc($unspsc = null)
    {
        // validation for constraint: string
        if (!is_null($unspsc) && !is_string($unspsc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unspsc, true), gettype($unspsc)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($unspsc) && mb_strlen($unspsc) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($unspsc)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($unspsc) && mb_strlen($unspsc) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($unspsc)), __LINE__);
        }
        $this->unspsc = $unspsc;
        return $this;
    }
    /**
     * Get gtin value
     * @return string|null
     */
    public function getGtin()
    {
        return $this->gtin;
    }
    /**
     * Set gtin value
     * @param string $gtin
     * @return \StructType\ProductPart
     */
    public function setGtin($gtin = null)
    {
        // validation for constraint: string
        if (!is_null($gtin) && !is_string($gtin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gtin, true), gettype($gtin)), __LINE__);
        }
        // validation for constraint: maxLength(14)
        if (!is_null($gtin) && mb_strlen($gtin) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 14', mb_strlen($gtin)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($gtin) && mb_strlen($gtin) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($gtin)), __LINE__);
        }
        $this->gtin = $gtin;
        return $this;
    }
    /**
     * Get isRushService value
     * @return bool|null
     */
    public function getIsRushService()
    {
        return $this->isRushService;
    }
    /**
     * Set isRushService value
     * @param bool $isRushService
     * @return \StructType\ProductPart
     */
    public function setIsRushService($isRushService = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRushService) && !is_bool($isRushService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRushService, true), gettype($isRushService)), __LINE__);
        }
        $this->isRushService = $isRushService;
        return $this;
    }
    /**
     * Get ProductPackagingArray value
     * @return \ArrayType\ProductPackagingArray|null
     */
    public function getProductPackagingArray()
    {
        return $this->ProductPackagingArray;
    }
    /**
     * Set ProductPackagingArray value
     * @param \ArrayType\ProductPackagingArray $productPackagingArray
     * @return \StructType\ProductPart
     */
    public function setProductPackagingArray(\ArrayType\ProductPackagingArray $productPackagingArray = null)
    {
        $this->ProductPackagingArray = $productPackagingArray;
        return $this;
    }
    /**
     * Get ShippingPackageArray value
     * @return \ArrayType\ShippingPackageArray|null
     */
    public function getShippingPackageArray()
    {
        return $this->ShippingPackageArray;
    }
    /**
     * Set ShippingPackageArray value
     * @param \ArrayType\ShippingPackageArray $shippingPackageArray
     * @return \StructType\ProductPart
     */
    public function setShippingPackageArray(\ArrayType\ShippingPackageArray $shippingPackageArray = null)
    {
        $this->ShippingPackageArray = $shippingPackageArray;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\ProductPart
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get effectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->effectiveDate;
    }
    /**
     * Set effectiveDate value
     * @param string $effectiveDate
     * @return \StructType\ProductPart
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->effectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get isCloseout value
     * @return bool|null
     */
    public function getIsCloseout()
    {
        return $this->isCloseout;
    }
    /**
     * Set isCloseout value
     * @param bool $isCloseout
     * @return \StructType\ProductPart
     */
    public function setIsCloseout($isCloseout = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCloseout) && !is_bool($isCloseout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCloseout, true), gettype($isCloseout)), __LINE__);
        }
        $this->isCloseout = $isCloseout;
        return $this;
    }
    /**
     * Get isCaution value
     * @return bool|null
     */
    public function getIsCaution()
    {
        return $this->isCaution;
    }
    /**
     * Set isCaution value
     * @param bool $isCaution
     * @return \StructType\ProductPart
     */
    public function setIsCaution($isCaution = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCaution) && !is_bool($isCaution)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCaution, true), gettype($isCaution)), __LINE__);
        }
        $this->isCaution = $isCaution;
        return $this;
    }
    /**
     * Get cautionComment value
     * @return string|null
     */
    public function getCautionComment()
    {
        return $this->cautionComment;
    }
    /**
     * Set cautionComment value
     * @param string $cautionComment
     * @return \StructType\ProductPart
     */
    public function setCautionComment($cautionComment = null)
    {
        // validation for constraint: string
        if (!is_null($cautionComment) && !is_string($cautionComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cautionComment, true), gettype($cautionComment)), __LINE__);
        }
        // validation for constraint: maxLength(1024)
        if (!is_null($cautionComment) && mb_strlen($cautionComment) > 1024) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1024', mb_strlen($cautionComment)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($cautionComment) && mb_strlen($cautionComment) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($cautionComment)), __LINE__);
        }
        $this->cautionComment = $cautionComment;
        return $this;
    }
    /**
     * Get nmfcCode value
     * @return float|null
     */
    public function getNmfcCode()
    {
        return $this->nmfcCode;
    }
    /**
     * Set nmfcCode value
     * @param float $nmfcCode
     * @return \StructType\ProductPart
     */
    public function setNmfcCode($nmfcCode = null)
    {
        // validation for constraint: float
        if (!is_null($nmfcCode) && !(is_float($nmfcCode) || is_numeric($nmfcCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($nmfcCode, true), gettype($nmfcCode)), __LINE__);
        }
        $this->nmfcCode = $nmfcCode;
        return $this;
    }
    /**
     * Get nmfcDescription value
     * @return string|null
     */
    public function getNmfcDescription()
    {
        return $this->nmfcDescription;
    }
    /**
     * Set nmfcDescription value
     * @param string $nmfcDescription
     * @return \StructType\ProductPart
     */
    public function setNmfcDescription($nmfcDescription = null)
    {
        // validation for constraint: string
        if (!is_null($nmfcDescription) && !is_string($nmfcDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmfcDescription, true), gettype($nmfcDescription)), __LINE__);
        }
        // validation for constraint: maxLength(1024)
        if (!is_null($nmfcDescription) && mb_strlen($nmfcDescription) > 1024) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1024', mb_strlen($nmfcDescription)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nmfcDescription) && mb_strlen($nmfcDescription) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nmfcDescription)), __LINE__);
        }
        $this->nmfcDescription = $nmfcDescription;
        return $this;
    }
    /**
     * Get nmfcNumber value
     * @return string|null
     */
    public function getNmfcNumber()
    {
        return $this->nmfcNumber;
    }
    /**
     * Set nmfcNumber value
     * @param string $nmfcNumber
     * @return \StructType\ProductPart
     */
    public function setNmfcNumber($nmfcNumber = null)
    {
        // validation for constraint: string
        if (!is_null($nmfcNumber) && !is_string($nmfcNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmfcNumber, true), gettype($nmfcNumber)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($nmfcNumber) && mb_strlen($nmfcNumber) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($nmfcNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nmfcNumber) && mb_strlen($nmfcNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nmfcNumber)), __LINE__);
        }
        $this->nmfcNumber = $nmfcNumber;
        return $this;
    }
    /**
     * Get isOnDemand value
     * @return bool|null
     */
    public function getIsOnDemand()
    {
        return $this->isOnDemand;
    }
    /**
     * Set isOnDemand value
     * @param bool $isOnDemand
     * @return \StructType\ProductPart
     */
    public function setIsOnDemand($isOnDemand = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOnDemand) && !is_bool($isOnDemand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOnDemand, true), gettype($isOnDemand)), __LINE__);
        }
        $this->isOnDemand = $isOnDemand;
        return $this;
    }
    /**
     * Get isHazmat value
     * @return bool|null
     */
    public function getIsHazmat()
    {
        return $this->isHazmat;
    }
    /**
     * Set isHazmat value
     * @param bool $isHazmat
     * @return \StructType\ProductPart
     */
    public function setIsHazmat($isHazmat = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHazmat) && !is_bool($isHazmat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHazmat, true), gettype($isHazmat)), __LINE__);
        }
        $this->isHazmat = $isHazmat;
        return $this;
    }
}
