<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductCategory StructType
 * @subpackage Structs
 */
class ProductCategory extends AbstractStructBase
{
    /**
     * The category
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 256
     * - minLength: 1
     * @var string
     */
    public $category;
    /**
     * The subCategory
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 256
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $subCategory;
    /**
     * Constructor method for ProductCategory
     * @uses ProductCategory::setCategory()
     * @uses ProductCategory::setSubCategory()
     * @param string $category
     * @param string $subCategory
     */
    public function __construct($category = null, $subCategory = null)
    {
        $this
            ->setCategory($category)
            ->setSubCategory($subCategory);
    }
    /**
     * Get category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\ProductCategory
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($category) && mb_strlen($category) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($category)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($category) && mb_strlen($category) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get subCategory value
     * @return string|null
     */
    public function getSubCategory()
    {
        return $this->subCategory;
    }
    /**
     * Set subCategory value
     * @param string $subCategory
     * @return \StructType\ProductCategory
     */
    public function setSubCategory($subCategory = null)
    {
        // validation for constraint: string
        if (!is_null($subCategory) && !is_string($subCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subCategory, true), gettype($subCategory)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($subCategory) && mb_strlen($subCategory) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($subCategory)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($subCategory) && mb_strlen($subCategory) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($subCategory)), __LINE__);
        }
        $this->subCategory = $subCategory;
        return $this;
    }
}
