<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetProductSellableRequest StructType
 * @subpackage Structs
 */
class GetProductSellableRequest extends AbstractStructBase
{
    /**
     * The wsVersion
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - ref: ns3:wsVersion
     * @var string
     */
    public $wsVersion;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - ref: ns3:id
     * @var string
     */
    public $id;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns3:password
     * @var string
     */
    public $password;
    /**
     * The localizationCountry
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 2
     * - minLength: 2
     * - minOccurs: 0
     * - ref: ns3:localizationCountry
     * @var string
     */
    public $localizationCountry;
    /**
     * The localizationLanguage
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 2
     * - minLength: 2
     * - minOccurs: 0
     * - ref: ns3:localizationLanguage
     * @var string
     */
    public $localizationLanguage;
    /**
     * The productId
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns3:productId
     * @var string
     */
    public $productId;
    /**
     * The partId
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns3:partId
     * @var string
     */
    public $partId;
    /**
     * The lineName
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns3:lineName
     * @var string
     */
    public $lineName;
    /**
     * The isSellable
     * Meta information extracted from the WSDL
     * - ref: ns3:isSellable
     * @var bool
     */
    public $isSellable;
    /**
     * Constructor method for GetProductSellableRequest
     * @uses GetProductSellableRequest::setWsVersion()
     * @uses GetProductSellableRequest::setId()
     * @uses GetProductSellableRequest::setPassword()
     * @uses GetProductSellableRequest::setLocalizationCountry()
     * @uses GetProductSellableRequest::setLocalizationLanguage()
     * @uses GetProductSellableRequest::setProductId()
     * @uses GetProductSellableRequest::setPartId()
     * @uses GetProductSellableRequest::setLineName()
     * @uses GetProductSellableRequest::setIsSellable()
     * @param string $wsVersion
     * @param string $id
     * @param string $password
     * @param string $localizationCountry
     * @param string $localizationLanguage
     * @param string $productId
     * @param string $partId
     * @param string $lineName
     * @param bool $isSellable
     */
    public function __construct($wsVersion = null, $id = null, $password = null, $localizationCountry = null, $localizationLanguage = null, $productId = null, $partId = null, $lineName = null, $isSellable = null)
    {
        $this
            ->setWsVersion($wsVersion)
            ->setId($id)
            ->setPassword($password)
            ->setLocalizationCountry($localizationCountry)
            ->setLocalizationLanguage($localizationLanguage)
            ->setProductId($productId)
            ->setPartId($partId)
            ->setLineName($lineName)
            ->setIsSellable($isSellable);
    }
    /**
     * Get wsVersion value
     * @return string|null
     */
    public function getWsVersion()
    {
        return $this->wsVersion;
    }
    /**
     * Set wsVersion value
     * @param string $wsVersion
     * @return \StructType\GetProductSellableRequest
     */
    public function setWsVersion($wsVersion = null)
    {
        // validation for constraint: string
        if (!is_null($wsVersion) && !is_string($wsVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wsVersion, true), gettype($wsVersion)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($wsVersion) && mb_strlen($wsVersion) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($wsVersion)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($wsVersion) && mb_strlen($wsVersion) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($wsVersion)), __LINE__);
        }
        $this->wsVersion = $wsVersion;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\GetProductSellableRequest
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($id) && mb_strlen($id) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($id)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($id) && mb_strlen($id) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\GetProductSellableRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($password) && mb_strlen($password) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($password)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($password) && mb_strlen($password) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get localizationCountry value
     * @return string|null
     */
    public function getLocalizationCountry()
    {
        return $this->localizationCountry;
    }
    /**
     * Set localizationCountry value
     * @param string $localizationCountry
     * @return \StructType\GetProductSellableRequest
     */
    public function setLocalizationCountry($localizationCountry = null)
    {
        // validation for constraint: string
        if (!is_null($localizationCountry) && !is_string($localizationCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localizationCountry, true), gettype($localizationCountry)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($localizationCountry) && mb_strlen($localizationCountry) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($localizationCountry)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($localizationCountry) && mb_strlen($localizationCountry) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($localizationCountry)), __LINE__);
        }
        $this->localizationCountry = $localizationCountry;
        return $this;
    }
    /**
     * Get localizationLanguage value
     * @return string|null
     */
    public function getLocalizationLanguage()
    {
        return $this->localizationLanguage;
    }
    /**
     * Set localizationLanguage value
     * @param string $localizationLanguage
     * @return \StructType\GetProductSellableRequest
     */
    public function setLocalizationLanguage($localizationLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($localizationLanguage) && !is_string($localizationLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localizationLanguage, true), gettype($localizationLanguage)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($localizationLanguage) && mb_strlen($localizationLanguage) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($localizationLanguage)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($localizationLanguage) && mb_strlen($localizationLanguage) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($localizationLanguage)), __LINE__);
        }
        $this->localizationLanguage = $localizationLanguage;
        return $this;
    }
    /**
     * Get productId value
     * @return string|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param string $productId
     * @return \StructType\GetProductSellableRequest
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($productId) && mb_strlen($productId) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($productId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($productId) && mb_strlen($productId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get partId value
     * @return string|null
     */
    public function getPartId()
    {
        return $this->partId;
    }
    /**
     * Set partId value
     * @param string $partId
     * @return \StructType\GetProductSellableRequest
     */
    public function setPartId($partId = null)
    {
        // validation for constraint: string
        if (!is_null($partId) && !is_string($partId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partId, true), gettype($partId)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($partId) && mb_strlen($partId) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($partId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($partId) && mb_strlen($partId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($partId)), __LINE__);
        }
        $this->partId = $partId;
        return $this;
    }
    /**
     * Get lineName value
     * @return string|null
     */
    public function getLineName()
    {
        return $this->lineName;
    }
    /**
     * Set lineName value
     * @param string $lineName
     * @return \StructType\GetProductSellableRequest
     */
    public function setLineName($lineName = null)
    {
        // validation for constraint: string
        if (!is_null($lineName) && !is_string($lineName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lineName, true), gettype($lineName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($lineName) && mb_strlen($lineName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($lineName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($lineName) && mb_strlen($lineName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($lineName)), __LINE__);
        }
        $this->lineName = $lineName;
        return $this;
    }
    /**
     * Get isSellable value
     * @return bool|null
     */
    public function getIsSellable()
    {
        return $this->isSellable;
    }
    /**
     * Set isSellable value
     * @param bool $isSellable
     * @return \StructType\GetProductSellableRequest
     */
    public function setIsSellable($isSellable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSellable) && !is_bool($isSellable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSellable, true), gettype($isSellable)), __LINE__);
        }
        $this->isSellable = $isSellable;
        return $this;
    }
}
