<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetProductResponse StructType
 * @subpackage Structs
 */
class GetProductResponse extends AbstractStructBase
{
    /**
     * The Product
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns1:Product
     * @var \StructType\Product
     */
    public $Product;
    /**
     * The ServiceMessageArray
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns3:ServiceMessageArray
     * @var \ArrayType\ServiceMessageArray
     */
    public $ServiceMessageArray;
    /**
     * Constructor method for GetProductResponse
     * @uses GetProductResponse::setProduct()
     * @uses GetProductResponse::setServiceMessageArray()
     * @param \StructType\Product $product
     * @param \ArrayType\ServiceMessageArray $serviceMessageArray
     */
    public function __construct(\StructType\Product $product = null, \ArrayType\ServiceMessageArray $serviceMessageArray = null)
    {
        $this
            ->setProduct($product)
            ->setServiceMessageArray($serviceMessageArray);
    }
    /**
     * Get Product value
     * @return \StructType\Product|null
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @param \StructType\Product $product
     * @return \StructType\GetProductResponse
     */
    public function setProduct(\StructType\Product $product = null)
    {
        $this->Product = $product;
        return $this;
    }
    /**
     * Get ServiceMessageArray value
     * @return \ArrayType\ServiceMessageArray|null
     */
    public function getServiceMessageArray()
    {
        return $this->ServiceMessageArray;
    }
    /**
     * Set ServiceMessageArray value
     * @param \ArrayType\ServiceMessageArray $serviceMessageArray
     * @return \StructType\GetProductResponse
     */
    public function setServiceMessageArray(\ArrayType\ServiceMessageArray $serviceMessageArray = null)
    {
        $this->ServiceMessageArray = $serviceMessageArray;
        return $this;
    }
}
