<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetProductDateModifiedRequest StructType
 * @subpackage Structs
 */
class GetProductDateModifiedRequest extends AbstractStructBase
{
    /**
     * The wsVersion
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - ref: ns3:wsVersion
     * @var string
     */
    public $wsVersion;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - ref: ns3:id
     * @var string
     */
    public $id;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns3:password
     * @var string
     */
    public $password;
    /**
     * The changeTimeStamp
     * Meta information extracted from the WSDL
     * - ref: ns3:changeTimeStamp
     * @var string
     */
    public $changeTimeStamp;
    /**
     * Constructor method for GetProductDateModifiedRequest
     * @uses GetProductDateModifiedRequest::setWsVersion()
     * @uses GetProductDateModifiedRequest::setId()
     * @uses GetProductDateModifiedRequest::setPassword()
     * @uses GetProductDateModifiedRequest::setChangeTimeStamp()
     * @param string $wsVersion
     * @param string $id
     * @param string $password
     * @param string $changeTimeStamp
     */
    public function __construct($wsVersion = null, $id = null, $password = null, $changeTimeStamp = null)
    {
        $this
            ->setWsVersion($wsVersion)
            ->setId($id)
            ->setPassword($password)
            ->setChangeTimeStamp($changeTimeStamp);
    }
    /**
     * Get wsVersion value
     * @return string|null
     */
    public function getWsVersion()
    {
        return $this->wsVersion;
    }
    /**
     * Set wsVersion value
     * @param string $wsVersion
     * @return \StructType\GetProductDateModifiedRequest
     */
    public function setWsVersion($wsVersion = null)
    {
        // validation for constraint: string
        if (!is_null($wsVersion) && !is_string($wsVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wsVersion, true), gettype($wsVersion)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($wsVersion) && mb_strlen($wsVersion) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($wsVersion)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($wsVersion) && mb_strlen($wsVersion) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($wsVersion)), __LINE__);
        }
        $this->wsVersion = $wsVersion;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\GetProductDateModifiedRequest
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($id) && mb_strlen($id) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($id)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($id) && mb_strlen($id) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\GetProductDateModifiedRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($password) && mb_strlen($password) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($password)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($password) && mb_strlen($password) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get changeTimeStamp value
     * @return string|null
     */
    public function getChangeTimeStamp()
    {
        return $this->changeTimeStamp;
    }
    /**
     * Set changeTimeStamp value
     * @param string $changeTimeStamp
     * @return \StructType\GetProductDateModifiedRequest
     */
    public function setChangeTimeStamp($changeTimeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($changeTimeStamp) && !is_string($changeTimeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changeTimeStamp, true), gettype($changeTimeStamp)), __LINE__);
        }
        $this->changeTimeStamp = $changeTimeStamp;
        return $this;
    }
}
