<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FobPoint StructType
 * @subpackage Structs
 */
class FobPoint extends AbstractStructBase
{
    /**
     * The fobId
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - ref: ns2:fobId
     * @var string
     */
    public $fobId;
    /**
     * The fobCity
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $fobCity;
    /**
     * The fobState
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $fobState;
    /**
     * The fobPostalCode
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 64
     * - minLength: 1
     * - ref: ns2:fobPostalCode
     * @var string
     */
    public $fobPostalCode;
    /**
     * The fobCountry
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $fobCountry;
    /**
     * Constructor method for FobPoint
     * @uses FobPoint::setFobId()
     * @uses FobPoint::setFobCity()
     * @uses FobPoint::setFobState()
     * @uses FobPoint::setFobPostalCode()
     * @uses FobPoint::setFobCountry()
     * @param string $fobId
     * @param string $fobCity
     * @param string $fobState
     * @param string $fobPostalCode
     * @param string $fobCountry
     */
    public function __construct($fobId = null, $fobCity = null, $fobState = null, $fobPostalCode = null, $fobCountry = null)
    {
        $this
            ->setFobId($fobId)
            ->setFobCity($fobCity)
            ->setFobState($fobState)
            ->setFobPostalCode($fobPostalCode)
            ->setFobCountry($fobCountry);
    }
    /**
     * Get fobId value
     * @return string|null
     */
    public function getFobId()
    {
        return $this->fobId;
    }
    /**
     * Set fobId value
     * @param string $fobId
     * @return \StructType\FobPoint
     */
    public function setFobId($fobId = null)
    {
        // validation for constraint: string
        if (!is_null($fobId) && !is_string($fobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fobId, true), gettype($fobId)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($fobId) && mb_strlen($fobId) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($fobId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($fobId) && mb_strlen($fobId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($fobId)), __LINE__);
        }
        $this->fobId = $fobId;
        return $this;
    }
    /**
     * Get fobCity value
     * @return string|null
     */
    public function getFobCity()
    {
        return $this->fobCity;
    }
    /**
     * Set fobCity value
     * @param string $fobCity
     * @return \StructType\FobPoint
     */
    public function setFobCity($fobCity = null)
    {
        // validation for constraint: string
        if (!is_null($fobCity) && !is_string($fobCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fobCity, true), gettype($fobCity)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($fobCity) && mb_strlen($fobCity) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($fobCity)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($fobCity) && mb_strlen($fobCity) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($fobCity)), __LINE__);
        }
        $this->fobCity = $fobCity;
        return $this;
    }
    /**
     * Get fobState value
     * @return string|null
     */
    public function getFobState()
    {
        return $this->fobState;
    }
    /**
     * Set fobState value
     * @param string $fobState
     * @return \StructType\FobPoint
     */
    public function setFobState($fobState = null)
    {
        // validation for constraint: string
        if (!is_null($fobState) && !is_string($fobState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fobState, true), gettype($fobState)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($fobState) && mb_strlen($fobState) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($fobState)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($fobState) && mb_strlen($fobState) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($fobState)), __LINE__);
        }
        $this->fobState = $fobState;
        return $this;
    }
    /**
     * Get fobPostalCode value
     * @return string|null
     */
    public function getFobPostalCode()
    {
        return $this->fobPostalCode;
    }
    /**
     * Set fobPostalCode value
     * @param string $fobPostalCode
     * @return \StructType\FobPoint
     */
    public function setFobPostalCode($fobPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($fobPostalCode) && !is_string($fobPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fobPostalCode, true), gettype($fobPostalCode)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($fobPostalCode) && mb_strlen($fobPostalCode) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($fobPostalCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($fobPostalCode) && mb_strlen($fobPostalCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($fobPostalCode)), __LINE__);
        }
        $this->fobPostalCode = $fobPostalCode;
        return $this;
    }
    /**
     * Get fobCountry value
     * @return string|null
     */
    public function getFobCountry()
    {
        return $this->fobCountry;
    }
    /**
     * Set fobCountry value
     * @param string $fobCountry
     * @return \StructType\FobPoint
     */
    public function setFobCountry($fobCountry = null)
    {
        // validation for constraint: string
        if (!is_null($fobCountry) && !is_string($fobCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fobCountry, true), gettype($fobCountry)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($fobCountry) && mb_strlen($fobCountry) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($fobCountry)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($fobCountry) && mb_strlen($fobCountry) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($fobCountry)), __LINE__);
        }
        $this->fobCountry = $fobCountry;
        return $this;
    }
}
