<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Dimension StructType
 * @subpackage Structs
 */
class Dimension extends AbstractStructBase
{
    /**
     * The dimensionUom
     * Meta information extracted from the WSDL
     * - base: ns2:dimensionUomEnum
     * - maxLength: 2
     * - minLength: 1
     * - ref: ns2:dimensionUom
     * @var string
     */
    public $dimensionUom;
    /**
     * The depth
     * Meta information extracted from the WSDL
     * - ref: ns2:depth
     * @var float
     */
    public $depth;
    /**
     * The height
     * Meta information extracted from the WSDL
     * - ref: ns2:height
     * @var float
     */
    public $height;
    /**
     * The width
     * Meta information extracted from the WSDL
     * - ref: ns2:width
     * @var float
     */
    public $width;
    /**
     * The weightUom
     * Meta information extracted from the WSDL
     * - base: ns2:weightUomEnum
     * - maxLength: 2
     * - minLength: 1
     * - ref: ns2:weightUom
     * @var string
     */
    public $weightUom;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - ref: ns2:weight
     * @var float
     */
    public $weight;
    /**
     * Constructor method for Dimension
     * @uses Dimension::setDimensionUom()
     * @uses Dimension::setDepth()
     * @uses Dimension::setHeight()
     * @uses Dimension::setWidth()
     * @uses Dimension::setWeightUom()
     * @uses Dimension::setWeight()
     * @param string $dimensionUom
     * @param float $depth
     * @param float $height
     * @param float $width
     * @param string $weightUom
     * @param float $weight
     */
    public function __construct($dimensionUom = null, $depth = null, $height = null, $width = null, $weightUom = null, $weight = null)
    {
        $this
            ->setDimensionUom($dimensionUom)
            ->setDepth($depth)
            ->setHeight($height)
            ->setWidth($width)
            ->setWeightUom($weightUom)
            ->setWeight($weight);
    }
    /**
     * Get dimensionUom value
     * @return string|null
     */
    public function getDimensionUom()
    {
        return $this->dimensionUom;
    }
    /**
     * Set dimensionUom value
     * @param string $dimensionUom
     * @return \StructType\Dimension
     */
    public function setDimensionUom($dimensionUom = null)
    {
        // validation for constraint: string
        if (!is_null($dimensionUom) && !is_string($dimensionUom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dimensionUom, true), gettype($dimensionUom)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($dimensionUom) && mb_strlen($dimensionUom) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($dimensionUom)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($dimensionUom) && mb_strlen($dimensionUom) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($dimensionUom)), __LINE__);
        }
        $this->dimensionUom = $dimensionUom;
        return $this;
    }
    /**
     * Get depth value
     * @return float|null
     */
    public function getDepth()
    {
        return $this->depth;
    }
    /**
     * Set depth value
     * @param float $depth
     * @return \StructType\Dimension
     */
    public function setDepth($depth = null)
    {
        // validation for constraint: float
        if (!is_null($depth) && !(is_float($depth) || is_numeric($depth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($depth, true), gettype($depth)), __LINE__);
        }
        $this->depth = $depth;
        return $this;
    }
    /**
     * Get height value
     * @return float|null
     */
    public function getHeight()
    {
        return $this->height;
    }
    /**
     * Set height value
     * @param float $height
     * @return \StructType\Dimension
     */
    public function setHeight($height = null)
    {
        // validation for constraint: float
        if (!is_null($height) && !(is_float($height) || is_numeric($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->height = $height;
        return $this;
    }
    /**
     * Get width value
     * @return float|null
     */
    public function getWidth()
    {
        return $this->width;
    }
    /**
     * Set width value
     * @param float $width
     * @return \StructType\Dimension
     */
    public function setWidth($width = null)
    {
        // validation for constraint: float
        if (!is_null($width) && !(is_float($width) || is_numeric($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->width = $width;
        return $this;
    }
    /**
     * Get weightUom value
     * @return string|null
     */
    public function getWeightUom()
    {
        return $this->weightUom;
    }
    /**
     * Set weightUom value
     * @param string $weightUom
     * @return \StructType\Dimension
     */
    public function setWeightUom($weightUom = null)
    {
        // validation for constraint: string
        if (!is_null($weightUom) && !is_string($weightUom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weightUom, true), gettype($weightUom)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($weightUom) && mb_strlen($weightUom) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($weightUom)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($weightUom) && mb_strlen($weightUom) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($weightUom)), __LINE__);
        }
        $this->weightUom = $weightUom;
        return $this;
    }
    /**
     * Get weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \StructType\Dimension
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
}
