<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Color StructType
 * @subpackage Structs
 */
class Color extends AbstractStructBase
{
    /**
     * The standardColorName
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $standardColorName;
    /**
     * The hex
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $hex;
    /**
     * The approximatePms
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $approximatePms;
    /**
     * The colorName
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $colorName;
    /**
     * Constructor method for Color
     * @uses Color::setStandardColorName()
     * @uses Color::setHex()
     * @uses Color::setApproximatePms()
     * @uses Color::setColorName()
     * @param string $standardColorName
     * @param string $hex
     * @param string $approximatePms
     * @param string $colorName
     */
    public function __construct($standardColorName = null, $hex = null, $approximatePms = null, $colorName = null)
    {
        $this
            ->setStandardColorName($standardColorName)
            ->setHex($hex)
            ->setApproximatePms($approximatePms)
            ->setColorName($colorName);
    }
    /**
     * Get standardColorName value
     * @return string|null
     */
    public function getStandardColorName()
    {
        return $this->standardColorName;
    }
    /**
     * Set standardColorName value
     * @param string $standardColorName
     * @return \StructType\Color
     */
    public function setStandardColorName($standardColorName = null)
    {
        // validation for constraint: string
        if (!is_null($standardColorName) && !is_string($standardColorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($standardColorName, true), gettype($standardColorName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($standardColorName) && mb_strlen($standardColorName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($standardColorName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($standardColorName) && mb_strlen($standardColorName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($standardColorName)), __LINE__);
        }
        $this->standardColorName = $standardColorName;
        return $this;
    }
    /**
     * Get hex value
     * @return string|null
     */
    public function getHex()
    {
        return $this->hex;
    }
    /**
     * Set hex value
     * @param string $hex
     * @return \StructType\Color
     */
    public function setHex($hex = null)
    {
        // validation for constraint: string
        if (!is_null($hex) && !is_string($hex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hex, true), gettype($hex)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($hex) && mb_strlen($hex) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($hex)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($hex) && mb_strlen($hex) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($hex)), __LINE__);
        }
        $this->hex = $hex;
        return $this;
    }
    /**
     * Get approximatePms value
     * @return string|null
     */
    public function getApproximatePms()
    {
        return $this->approximatePms;
    }
    /**
     * Set approximatePms value
     * @param string $approximatePms
     * @return \StructType\Color
     */
    public function setApproximatePms($approximatePms = null)
    {
        // validation for constraint: string
        if (!is_null($approximatePms) && !is_string($approximatePms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approximatePms, true), gettype($approximatePms)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($approximatePms) && mb_strlen($approximatePms) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($approximatePms)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($approximatePms) && mb_strlen($approximatePms) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($approximatePms)), __LINE__);
        }
        $this->approximatePms = $approximatePms;
        return $this;
    }
    /**
     * Get colorName value
     * @return string|null
     */
    public function getColorName()
    {
        return $this->colorName;
    }
    /**
     * Set colorName value
     * @param string $colorName
     * @return \StructType\Color
     */
    public function setColorName($colorName = null)
    {
        // validation for constraint: string
        if (!is_null($colorName) && !is_string($colorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($colorName, true), gettype($colorName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($colorName) && mb_strlen($colorName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($colorName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($colorName) && mb_strlen($colorName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($colorName)), __LINE__);
        }
        $this->colorName = $colorName;
        return $this;
    }
}
