<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApparelSize StructType
 * @subpackage Structs
 */
class ApparelSize extends AbstractStructBase
{
    /**
     * The apparelStyle
     * Meta information extracted from the WSDL
     * - base: ns2:apparelStyleEnum
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $apparelStyle;
    /**
     * The labelSize
     * Meta information extracted from the WSDL
     * - base: ns2:labelSizeEnum
     * - maxLength: 6
     * - minLength: 1
     * @var string
     */
    public $labelSize;
    /**
     * The customSize
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $customSize;
    /**
     * Constructor method for ApparelSize
     * @uses ApparelSize::setApparelStyle()
     * @uses ApparelSize::setLabelSize()
     * @uses ApparelSize::setCustomSize()
     * @param string $apparelStyle
     * @param string $labelSize
     * @param string $customSize
     */
    public function __construct($apparelStyle = null, $labelSize = null, $customSize = null)
    {
        $this
            ->setApparelStyle($apparelStyle)
            ->setLabelSize($labelSize)
            ->setCustomSize($customSize);
    }
    /**
     * Get apparelStyle value
     * @return string|null
     */
    public function getApparelStyle()
    {
        return $this->apparelStyle;
    }
    /**
     * Set apparelStyle value
     * @param string $apparelStyle
     * @return \StructType\ApparelSize
     */
    public function setApparelStyle($apparelStyle = null)
    {
        // validation for constraint: string
        if (!is_null($apparelStyle) && !is_string($apparelStyle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apparelStyle, true), gettype($apparelStyle)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($apparelStyle) && mb_strlen($apparelStyle) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($apparelStyle)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($apparelStyle) && mb_strlen($apparelStyle) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($apparelStyle)), __LINE__);
        }
        $this->apparelStyle = $apparelStyle;
        return $this;
    }
    /**
     * Get labelSize value
     * @return string|null
     */
    public function getLabelSize()
    {
        return $this->labelSize;
    }
    /**
     * Set labelSize value
     * @param string $labelSize
     * @return \StructType\ApparelSize
     */
    public function setLabelSize($labelSize = null)
    {
        // validation for constraint: string
        if (!is_null($labelSize) && !is_string($labelSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelSize, true), gettype($labelSize)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($labelSize) && mb_strlen($labelSize) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($labelSize)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($labelSize) && mb_strlen($labelSize) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($labelSize)), __LINE__);
        }
        $this->labelSize = $labelSize;
        return $this;
    }
    /**
     * Get customSize value
     * @return string|null
     */
    public function getCustomSize()
    {
        return $this->customSize;
    }
    /**
     * Set customSize value
     * @param string $customSize
     * @return \StructType\ApparelSize
     */
    public function setCustomSize($customSize = null)
    {
        // validation for constraint: string
        if (!is_null($customSize) && !is_string($customSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customSize, true), gettype($customSize)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($customSize) && mb_strlen($customSize) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($customSize)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($customSize) && mb_strlen($customSize) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($customSize)), __LINE__);
        }
        $this->customSize = $customSize;
        return $this;
    }
}
