<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getProduct
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProductRequest $getProductRequest
     * @return \StructType\GetProductResponse|bool
     */
    public function getProduct(\StructType\GetProductRequest $getProductRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->getProduct($getProductRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductSellable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProductSellableRequest $getProductSellableRequest
     * @return \StructType\GetProductSellableResponse|bool
     */
    public function getProductSellable(\StructType\GetProductSellableRequest $getProductSellableRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->getProductSellable($getProductSellableRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductCloseOut
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProductCloseOutRequest $getProductCloseOutRequest
     * @return \StructType\GetProductCloseOutResponse|bool
     */
    public function getProductCloseOut(\StructType\GetProductCloseOutRequest $getProductCloseOutRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->getProductCloseOut($getProductCloseOutRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductDateModified
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProductDateModifiedRequest $getProductDateModifiedRequest
     * @return \StructType\GetProductDateModifiedResponse|bool
     */
    public function getProductDateModified(\StructType\GetProductDateModifiedRequest $getProductDateModifiedRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->getProductDateModified($getProductDateModifiedRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetProductCloseOutResponse|\StructType\GetProductDateModifiedResponse|\StructType\GetProductResponse|\StructType\GetProductSellableResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
