<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for TaxCategoryArray ArrayType
 * @subpackage Arrays
 */
class TaxCategoryArray extends AbstractStructArrayBase
{
    /**
     * The TaxCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $TaxCategory;
    /**
     * Constructor method for TaxCategoryArray
     * @uses TaxCategoryArray::setTaxCategory()
     * @param mixed[] $taxCategory
     */
    public function __construct(array $taxCategory = array())
    {
        $this
            ->setTaxCategory($taxCategory);
    }
    /**
     * Get TaxCategory value
     * @return mixed[]|null
     */
    public function getTaxCategory()
    {
        return $this->TaxCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxCategoryForArrayConstraintsFromSetTaxCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxCategoryArrayTaxCategoryItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($taxCategoryArrayTaxCategoryItem) ? get_class($taxCategoryArrayTaxCategoryItem) : sprintf('%s(%s)', gettype($taxCategoryArrayTaxCategoryItem), var_export($taxCategoryArrayTaxCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxCategory property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxCategory value
     * @throws \InvalidArgumentException
     * @param mixed[] $taxCategory
     * @return \ArrayType\TaxCategoryArray
     */
    public function setTaxCategory(array $taxCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($taxCategoryArrayErrorMessage = self::validateTaxCategoryForArrayConstraintsFromSetTaxCategory($taxCategory))) {
            throw new \InvalidArgumentException($taxCategoryArrayErrorMessage, __LINE__);
        }
        $this->TaxCategory = $taxCategory;
        return $this;
    }
    /**
     * Add item to TaxCategory value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \ArrayType\TaxCategoryArray
     */
    public function addToTaxCategory($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The TaxCategory property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxCategory[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return mixed|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return mixed|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return mixed|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return mixed|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return mixed|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TaxCategory
     */
    public function getAttributeName()
    {
        return 'TaxCategory';
    }
}
