<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for SpecificationArray ArrayType
 * @subpackage Arrays
 */
class SpecificationArray extends AbstractStructArrayBase
{
    /**
     * The Specification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns3:Specification
     * @var \StructType\Specification[]
     */
    public $Specification;
    /**
     * Constructor method for SpecificationArray
     * @uses SpecificationArray::setSpecification()
     * @param \StructType\Specification[] $specification
     */
    public function __construct(array $specification = array())
    {
        $this
            ->setSpecification($specification);
    }
    /**
     * Get Specification value
     * @return \StructType\Specification[]|null
     */
    public function getSpecification()
    {
        return $this->Specification;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecificationForArrayConstraintsFromSetSpecification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $specificationArraySpecificationItem) {
            // validation for constraint: itemType
            if (!$specificationArraySpecificationItem instanceof \StructType\Specification) {
                $invalidValues[] = is_object($specificationArraySpecificationItem) ? get_class($specificationArraySpecificationItem) : sprintf('%s(%s)', gettype($specificationArraySpecificationItem), var_export($specificationArraySpecificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Specification property can only contain items of type \StructType\Specification, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Specification value
     * @throws \InvalidArgumentException
     * @param \StructType\Specification[] $specification
     * @return \ArrayType\SpecificationArray
     */
    public function setSpecification(array $specification = array())
    {
        // validation for constraint: array
        if ('' !== ($specificationArrayErrorMessage = self::validateSpecificationForArrayConstraintsFromSetSpecification($specification))) {
            throw new \InvalidArgumentException($specificationArrayErrorMessage, __LINE__);
        }
        $this->Specification = $specification;
        return $this;
    }
    /**
     * Add item to Specification value
     * @throws \InvalidArgumentException
     * @param \StructType\Specification $item
     * @return \ArrayType\SpecificationArray
     */
    public function addToSpecification(\StructType\Specification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Specification) {
            throw new \InvalidArgumentException(sprintf('The Specification property can only contain items of type \StructType\Specification, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Specification[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Specification|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Specification|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Specification|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Specification|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Specification|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Specification
     */
    public function getAttributeName()
    {
        return 'Specification';
    }
}
