<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ServiceMessageArray ArrayType
 * @subpackage Arrays
 */
class ServiceMessageArray extends AbstractStructArrayBase
{
    /**
     * The ServiceMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns2:ServiceMessage
     * @var \StructType\ServiceMessage[]
     */
    public $ServiceMessage;
    /**
     * Constructor method for ServiceMessageArray
     * @uses ServiceMessageArray::setServiceMessage()
     * @param \StructType\ServiceMessage[] $serviceMessage
     */
    public function __construct(array $serviceMessage = array())
    {
        $this
            ->setServiceMessage($serviceMessage);
    }
    /**
     * Get ServiceMessage value
     * @return \StructType\ServiceMessage[]|null
     */
    public function getServiceMessage()
    {
        return $this->ServiceMessage;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceMessage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceMessage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceMessageForArrayConstraintsFromSetServiceMessage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceMessageArrayServiceMessageItem) {
            // validation for constraint: itemType
            if (!$serviceMessageArrayServiceMessageItem instanceof \StructType\ServiceMessage) {
                $invalidValues[] = is_object($serviceMessageArrayServiceMessageItem) ? get_class($serviceMessageArrayServiceMessageItem) : sprintf('%s(%s)', gettype($serviceMessageArrayServiceMessageItem), var_export($serviceMessageArrayServiceMessageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceMessage property can only contain items of type \StructType\ServiceMessage, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceMessage[] $serviceMessage
     * @return \ArrayType\ServiceMessageArray
     */
    public function setServiceMessage(array $serviceMessage = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceMessageArrayErrorMessage = self::validateServiceMessageForArrayConstraintsFromSetServiceMessage($serviceMessage))) {
            throw new \InvalidArgumentException($serviceMessageArrayErrorMessage, __LINE__);
        }
        $this->ServiceMessage = $serviceMessage;
        return $this;
    }
    /**
     * Add item to ServiceMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceMessage $item
     * @return \ArrayType\ServiceMessageArray
     */
    public function addToServiceMessage(\StructType\ServiceMessage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceMessage) {
            throw new \InvalidArgumentException(sprintf('The ServiceMessage property can only contain items of type \StructType\ServiceMessage, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceMessage[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ServiceMessage|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ServiceMessage|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ServiceMessage|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ServiceMessage|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ServiceMessage|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ServiceMessage
     */
    public function getAttributeName()
    {
        return 'ServiceMessage';
    }
}
