<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ProductPriceArray ArrayType
 * @subpackage Arrays
 */
class ProductPriceArray extends AbstractStructArrayBase
{
    /**
     * The ProductPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - ref: ns2:ProductPrice
     * @var \StructType\ProductPrice[]
     */
    public $ProductPrice;
    /**
     * Constructor method for ProductPriceArray
     * @uses ProductPriceArray::setProductPrice()
     * @param \StructType\ProductPrice[] $productPrice
     */
    public function __construct(array $productPrice = array())
    {
        $this
            ->setProductPrice($productPrice);
    }
    /**
     * Get ProductPrice value
     * @return \StructType\ProductPrice[]
     */
    public function getProductPrice()
    {
        return $this->ProductPrice;
    }
    /**
     * This method is responsible for validating the values passed to the setProductPrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductPrice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductPriceForArrayConstraintsFromSetProductPrice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productPriceArrayProductPriceItem) {
            // validation for constraint: itemType
            if (!$productPriceArrayProductPriceItem instanceof \StructType\ProductPrice) {
                $invalidValues[] = is_object($productPriceArrayProductPriceItem) ? get_class($productPriceArrayProductPriceItem) : sprintf('%s(%s)', gettype($productPriceArrayProductPriceItem), var_export($productPriceArrayProductPriceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProductPrice property can only contain items of type \StructType\ProductPrice, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProductPrice value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductPrice[] $productPrice
     * @return \ArrayType\ProductPriceArray
     */
    public function setProductPrice(array $productPrice = array())
    {
        // validation for constraint: array
        if ('' !== ($productPriceArrayErrorMessage = self::validateProductPriceForArrayConstraintsFromSetProductPrice($productPrice))) {
            throw new \InvalidArgumentException($productPriceArrayErrorMessage, __LINE__);
        }
        $this->ProductPrice = $productPrice;
        return $this;
    }
    /**
     * Add item to ProductPrice value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductPrice $item
     * @return \ArrayType\ProductPriceArray
     */
    public function addToProductPrice(\StructType\ProductPrice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductPrice) {
            throw new \InvalidArgumentException(sprintf('The ProductPrice property can only contain items of type \StructType\ProductPrice, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProductPrice[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductPrice
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductPrice
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductPrice
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductPrice
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductPrice
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductPrice
     */
    public function getAttributeName()
    {
        return 'ProductPrice';
    }
}
