<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ProductPackagingArray ArrayType
 * @subpackage Arrays
 */
class ProductPackagingArray extends AbstractStructArrayBase
{
    /**
     * The ProductPackage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns3:ProductPackage
     * @var \StructType\ProductPackage[]
     */
    public $ProductPackage;
    /**
     * Constructor method for ProductPackagingArray
     * @uses ProductPackagingArray::setProductPackage()
     * @param \StructType\ProductPackage[] $productPackage
     */
    public function __construct(array $productPackage = array())
    {
        $this
            ->setProductPackage($productPackage);
    }
    /**
     * Get ProductPackage value
     * @return \StructType\ProductPackage[]|null
     */
    public function getProductPackage()
    {
        return $this->ProductPackage;
    }
    /**
     * This method is responsible for validating the values passed to the setProductPackage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductPackage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductPackageForArrayConstraintsFromSetProductPackage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productPackagingArrayProductPackageItem) {
            // validation for constraint: itemType
            if (!$productPackagingArrayProductPackageItem instanceof \StructType\ProductPackage) {
                $invalidValues[] = is_object($productPackagingArrayProductPackageItem) ? get_class($productPackagingArrayProductPackageItem) : sprintf('%s(%s)', gettype($productPackagingArrayProductPackageItem), var_export($productPackagingArrayProductPackageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProductPackage property can only contain items of type \StructType\ProductPackage, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProductPackage value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductPackage[] $productPackage
     * @return \ArrayType\ProductPackagingArray
     */
    public function setProductPackage(array $productPackage = array())
    {
        // validation for constraint: array
        if ('' !== ($productPackageArrayErrorMessage = self::validateProductPackageForArrayConstraintsFromSetProductPackage($productPackage))) {
            throw new \InvalidArgumentException($productPackageArrayErrorMessage, __LINE__);
        }
        $this->ProductPackage = $productPackage;
        return $this;
    }
    /**
     * Add item to ProductPackage value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductPackage $item
     * @return \ArrayType\ProductPackagingArray
     */
    public function addToProductPackage(\StructType\ProductPackage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductPackage) {
            throw new \InvalidArgumentException(sprintf('The ProductPackage property can only contain items of type \StructType\ProductPackage, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProductPackage[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductPackage|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductPackage|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductPackage|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductPackage|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductPackage|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductPackage
     */
    public function getAttributeName()
    {
        return 'ProductPackage';
    }
}
