<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ProductCategoryArray ArrayType
 * @subpackage Arrays
 */
class ProductCategoryArray extends AbstractStructArrayBase
{
    /**
     * The ProductCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns3:ProductCategory
     * @var \StructType\ProductCategory[]
     */
    public $ProductCategory;
    /**
     * Constructor method for ProductCategoryArray
     * @uses ProductCategoryArray::setProductCategory()
     * @param \StructType\ProductCategory[] $productCategory
     */
    public function __construct(array $productCategory = array())
    {
        $this
            ->setProductCategory($productCategory);
    }
    /**
     * Get ProductCategory value
     * @return \StructType\ProductCategory[]|null
     */
    public function getProductCategory()
    {
        return $this->ProductCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setProductCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductCategoryForArrayConstraintsFromSetProductCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productCategoryArrayProductCategoryItem) {
            // validation for constraint: itemType
            if (!$productCategoryArrayProductCategoryItem instanceof \StructType\ProductCategory) {
                $invalidValues[] = is_object($productCategoryArrayProductCategoryItem) ? get_class($productCategoryArrayProductCategoryItem) : sprintf('%s(%s)', gettype($productCategoryArrayProductCategoryItem), var_export($productCategoryArrayProductCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProductCategory property can only contain items of type \StructType\ProductCategory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProductCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductCategory[] $productCategory
     * @return \ArrayType\ProductCategoryArray
     */
    public function setProductCategory(array $productCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($productCategoryArrayErrorMessage = self::validateProductCategoryForArrayConstraintsFromSetProductCategory($productCategory))) {
            throw new \InvalidArgumentException($productCategoryArrayErrorMessage, __LINE__);
        }
        $this->ProductCategory = $productCategory;
        return $this;
    }
    /**
     * Add item to ProductCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductCategory $item
     * @return \ArrayType\ProductCategoryArray
     */
    public function addToProductCategory(\StructType\ProductCategory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductCategory) {
            throw new \InvalidArgumentException(sprintf('The ProductCategory property can only contain items of type \StructType\ProductCategory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProductCategory[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductCategory|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductCategory|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductCategory|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductCategory|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductCategory|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductCategory
     */
    public function getAttributeName()
    {
        return 'ProductCategory';
    }
}
