<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ColorArray ArrayType
 * @subpackage Arrays
 */
class ColorArray extends AbstractStructArrayBase
{
    /**
     * The Color
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns3:Color
     * @var \StructType\Color[]
     */
    public $Color;
    /**
     * Constructor method for ColorArray
     * @uses ColorArray::setColor()
     * @param \StructType\Color[] $color
     */
    public function __construct(array $color = array())
    {
        $this
            ->setColor($color);
    }
    /**
     * Get Color value
     * @return \StructType\Color[]|null
     */
    public function getColor()
    {
        return $this->Color;
    }
    /**
     * This method is responsible for validating the values passed to the setColor method
     * This method is willingly generated in order to preserve the one-line inline validation within the setColor method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateColorForArrayConstraintsFromSetColor(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $colorArrayColorItem) {
            // validation for constraint: itemType
            if (!$colorArrayColorItem instanceof \StructType\Color) {
                $invalidValues[] = is_object($colorArrayColorItem) ? get_class($colorArrayColorItem) : sprintf('%s(%s)', gettype($colorArrayColorItem), var_export($colorArrayColorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Color property can only contain items of type \StructType\Color, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Color value
     * @throws \InvalidArgumentException
     * @param \StructType\Color[] $color
     * @return \ArrayType\ColorArray
     */
    public function setColor(array $color = array())
    {
        // validation for constraint: array
        if ('' !== ($colorArrayErrorMessage = self::validateColorForArrayConstraintsFromSetColor($color))) {
            throw new \InvalidArgumentException($colorArrayErrorMessage, __LINE__);
        }
        $this->Color = $color;
        return $this;
    }
    /**
     * Add item to Color value
     * @throws \InvalidArgumentException
     * @param \StructType\Color $item
     * @return \ArrayType\ColorArray
     */
    public function addToColor(\StructType\Color $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Color) {
            throw new \InvalidArgumentException(sprintf('The Color property can only contain items of type \StructType\Color, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Color[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Color|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Color|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Color|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Color|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Color|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Color
     */
    public function getAttributeName()
    {
        return 'Color';
    }
}
