<?php

namespace optsoapsdk\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CreateAgent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \optsoapsdk\StructType\CreateAgent $parameters
     * @return \optsoapsdk\StructType\CreateAgentResponse|bool
     */
    public function CreateAgent(\optsoapsdk\StructType\CreateAgent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAgent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateReferral
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \optsoapsdk\StructType\CreateReferral $parameters
     * @return \optsoapsdk\StructType\CreateReferralResponse|bool
     */
    public function CreateReferral(\optsoapsdk\StructType\CreateReferral $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateReferral($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateApplicationTaken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \optsoapsdk\StructType\CreateApplicationTaken $parameters
     * @return \optsoapsdk\StructType\CreateApplicationTakenResponse|bool
     */
    public function CreateApplicationTaken(\optsoapsdk\StructType\CreateApplicationTaken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateApplicationTaken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \optsoapsdk\StructType\CreateAgentResponse|\optsoapsdk\StructType\CreateApplicationTakenResponse|\optsoapsdk\StructType\CreateReferralResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
