<?php

namespace optsoapsdk;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'ArrayOfstring' => '\\optsoapsdk\\ArrayType\\ArrayOfstring',
            'agentLogin' => '\\optsoapsdk\\StructType\\AgentLogin',
            'AgentDetails' => '\\optsoapsdk\\StructType\\AgentDetails',
            'AgentResponse' => '\\optsoapsdk\\StructType\\AgentResponse',
            'GetResponse' => '\\optsoapsdk\\StructType\\GetResponse',
            'Response' => '\\optsoapsdk\\StructType\\Response',
            'AgentInfo' => '\\optsoapsdk\\StructType\\AgentInfo',
            'UpdateDetails' => '\\optsoapsdk\\StructType\\UpdateDetails',
            'LeadDetail' => '\\optsoapsdk\\StructType\\LeadDetail',
            'CreateSchedule' => '\\optsoapsdk\\StructType\\CreateSchedule',
            'CreateNote' => '\\optsoapsdk\\StructType\\CreateNote',
            'ApplicationDetail' => '\\optsoapsdk\\StructType\\ApplicationDetail',
            'ApplicationCount' => '\\optsoapsdk\\StructType\\ApplicationCount',
            'LeadInfo' => '\\optsoapsdk\\StructType\\LeadInfo',
            'LeadResponse' => '\\optsoapsdk\\StructType\\LeadResponse',
            'ApplicationData' => '\\optsoapsdk\\StructType\\ApplicationData',
            'ApplicationCreated' => '\\optsoapsdk\\StructType\\ApplicationCreated',
            'PopupData' => '\\optsoapsdk\\StructType\\PopupData',
            'DXLead' => '\\optsoapsdk\\StructType\\DXLead',
            'ResponseVal' => '\\optsoapsdk\\StructType\\ResponseVal',
            'ValidateLogin' => '\\optsoapsdk\\StructType\\ValidateLogin',
            'ValidateLoginResponse' => '\\optsoapsdk\\StructType\\ValidateLoginResponse',
            'CreateAgent' => '\\optsoapsdk\\StructType\\CreateAgent',
            'CreateAgentResponse' => '\\optsoapsdk\\StructType\\CreateAgentResponse',
            'GetAgentDetail' => '\\optsoapsdk\\StructType\\GetAgentDetail',
            'GetAgentDetailResponse' => '\\optsoapsdk\\StructType\\GetAgentDetailResponse',
            'UpdateAgent' => '\\optsoapsdk\\StructType\\UpdateAgent',
            'UpdateAgentResponse' => '\\optsoapsdk\\StructType\\UpdateAgentResponse',
            'UpdateAgentLevelUpline' => '\\optsoapsdk\\StructType\\UpdateAgentLevelUpline',
            'UpdateAgentLevelUplineResponse' => '\\optsoapsdk\\StructType\\UpdateAgentLevelUplineResponse',
            'SetToInactive' => '\\optsoapsdk\\StructType\\SetToInactive',
            'SetToInactiveResponse' => '\\optsoapsdk\\StructType\\SetToInactiveResponse',
            'GetAgentLeads' => '\\optsoapsdk\\StructType\\GetAgentLeads',
            'GetAgentLeadsResponse' => '\\optsoapsdk\\StructType\\GetAgentLeadsResponse',
            'GetLeadDetail' => '\\optsoapsdk\\StructType\\GetLeadDetail',
            'GetLeadDetailResponse' => '\\optsoapsdk\\StructType\\GetLeadDetailResponse',
            'UpdateLead' => '\\optsoapsdk\\StructType\\UpdateLead',
            'UpdateLeadResponse' => '\\optsoapsdk\\StructType\\UpdateLeadResponse',
            'GetAgentLeadsSinceDate' => '\\optsoapsdk\\StructType\\GetAgentLeadsSinceDate',
            'GetAgentLeadsSinceDateResponse' => '\\optsoapsdk\\StructType\\GetAgentLeadsSinceDateResponse',
            'ChangeStatusWithSchedule' => '\\optsoapsdk\\StructType\\ChangeStatusWithSchedule',
            'ChangeStatusWithScheduleResponse' => '\\optsoapsdk\\StructType\\ChangeStatusWithScheduleResponse',
            'ChangeStatusWithNote' => '\\optsoapsdk\\StructType\\ChangeStatusWithNote',
            'ChangeStatusWithNoteResponse' => '\\optsoapsdk\\StructType\\ChangeStatusWithNoteResponse',
            'GetAgentApplicationsSinceDate' => '\\optsoapsdk\\StructType\\GetAgentApplicationsSinceDate',
            'GetAgentApplicationsSinceDateResponse' => '\\optsoapsdk\\StructType\\GetAgentApplicationsSinceDateResponse',
            'GetAgentApplicationsSinceLast30Days' => '\\optsoapsdk\\StructType\\GetAgentApplicationsSinceLast30Days',
            'GetAgentApplicationsSinceLast30DaysResponse' => '\\optsoapsdk\\StructType\\GetAgentApplicationsSinceLast30DaysResponse',
            'GetApplication' => '\\optsoapsdk\\StructType\\GetApplication',
            'GetApplicationResponse' => '\\optsoapsdk\\StructType\\GetApplicationResponse',
            'GetApplicationsCount' => '\\optsoapsdk\\StructType\\GetApplicationsCount',
            'GetApplicationsCountResponse' => '\\optsoapsdk\\StructType\\GetApplicationsCountResponse',
            'CreateReferral' => '\\optsoapsdk\\StructType\\CreateReferral',
            'CreateReferralResponse' => '\\optsoapsdk\\StructType\\CreateReferralResponse',
            'CreateApplicationTaken' => '\\optsoapsdk\\StructType\\CreateApplicationTaken',
            'CreateApplicationTakenResponse' => '\\optsoapsdk\\StructType\\CreateApplicationTakenResponse',
            'ApplicationPopUps' => '\\optsoapsdk\\StructType\\ApplicationPopUps',
            'ApplicationPopUpsResponse' => '\\optsoapsdk\\StructType\\ApplicationPopUpsResponse',
            'GetPolicyType' => '\\optsoapsdk\\StructType\\GetPolicyType',
            'GetPolicyTypeResponse' => '\\optsoapsdk\\StructType\\GetPolicyTypeResponse',
            'AddDXIALead' => '\\optsoapsdk\\StructType\\AddDXIALead',
            'AddDXIALeadResponse' => '\\optsoapsdk\\StructType\\AddDXIALeadResponse',
        );
    }
}
