<?php

namespace optsoapsdk\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Change ServiceType
 * @subpackage Services
 */
class Change extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ChangeStatusWithSchedule
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \optsoapsdk\StructType\ChangeStatusWithSchedule $parameters
     * @return \optsoapsdk\StructType\ChangeStatusWithScheduleResponse|bool
     */
    public function ChangeStatusWithSchedule(\optsoapsdk\StructType\ChangeStatusWithSchedule $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ChangeStatusWithSchedule($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChangeStatusWithNote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \optsoapsdk\StructType\ChangeStatusWithNote $parameters
     * @return \optsoapsdk\StructType\ChangeStatusWithNoteResponse|bool
     */
    public function ChangeStatusWithNote(\optsoapsdk\StructType\ChangeStatusWithNote $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ChangeStatusWithNote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \optsoapsdk\StructType\ChangeStatusWithNoteResponse|\optsoapsdk\StructType\ChangeStatusWithScheduleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
