<?php

namespace optsoapsdk\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAgentDetail StructType
 * @subpackage Structs
 */
class GetAgentDetail extends AbstractStructBase
{
    /**
     * The CID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CID;
    /**
     * The AgentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AgentID;
    /**
     * Constructor method for GetAgentDetail
     * @uses GetAgentDetail::setCID()
     * @uses GetAgentDetail::setAgentID()
     * @param string $cID
     * @param string $agentID
     */
    public function __construct($cID = null, $agentID = null)
    {
        $this
            ->setCID($cID)
            ->setAgentID($agentID);
    }
    /**
     * Get CID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCID()
    {
        return isset($this->CID) ? $this->CID : null;
    }
    /**
     * Set CID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cID
     * @return \optsoapsdk\StructType\GetAgentDetail
     */
    public function setCID($cID = null)
    {
        // validation for constraint: string
        if (!is_null($cID) && !is_string($cID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cID, true), gettype($cID)), __LINE__);
        }
        if (is_null($cID) || (is_array($cID) && empty($cID))) {
            unset($this->CID);
        } else {
            $this->CID = $cID;
        }
        return $this;
    }
    /**
     * Get AgentID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgentID()
    {
        return isset($this->AgentID) ? $this->AgentID : null;
    }
    /**
     * Set AgentID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agentID
     * @return \optsoapsdk\StructType\GetAgentDetail
     */
    public function setAgentID($agentID = null)
    {
        // validation for constraint: string
        if (!is_null($agentID) && !is_string($agentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentID, true), gettype($agentID)), __LINE__);
        }
        if (is_null($agentID) || (is_array($agentID) && empty($agentID))) {
            unset($this->AgentID);
        } else {
            $this->AgentID = $agentID;
        }
        return $this;
    }
}
