<?php

namespace optsoapsdk\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateLead StructType
 * @subpackage Structs
 */
class UpdateLead extends AbstractStructBase
{
    /**
     * The CID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CID;
    /**
     * The LeadCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LeadCode;
    /**
     * The AgentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AgentID;
    /**
     * The AccountType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountType;
    /**
     * The EmailIDSignedInWith
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailIDSignedInWith;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Comments;
    /**
     * Constructor method for UpdateLead
     * @uses UpdateLead::setCID()
     * @uses UpdateLead::setLeadCode()
     * @uses UpdateLead::setAgentID()
     * @uses UpdateLead::setAccountType()
     * @uses UpdateLead::setEmailIDSignedInWith()
     * @uses UpdateLead::setStatus()
     * @uses UpdateLead::setComments()
     * @param string $cID
     * @param string $leadCode
     * @param string $agentID
     * @param string $accountType
     * @param string $emailIDSignedInWith
     * @param string $status
     * @param string $comments
     */
    public function __construct($cID = null, $leadCode = null, $agentID = null, $accountType = null, $emailIDSignedInWith = null, $status = null, $comments = null)
    {
        $this
            ->setCID($cID)
            ->setLeadCode($leadCode)
            ->setAgentID($agentID)
            ->setAccountType($accountType)
            ->setEmailIDSignedInWith($emailIDSignedInWith)
            ->setStatus($status)
            ->setComments($comments);
    }
    /**
     * Get CID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCID()
    {
        return isset($this->CID) ? $this->CID : null;
    }
    /**
     * Set CID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cID
     * @return \optsoapsdk\StructType\UpdateLead
     */
    public function setCID($cID = null)
    {
        // validation for constraint: string
        if (!is_null($cID) && !is_string($cID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cID, true), gettype($cID)), __LINE__);
        }
        if (is_null($cID) || (is_array($cID) && empty($cID))) {
            unset($this->CID);
        } else {
            $this->CID = $cID;
        }
        return $this;
    }
    /**
     * Get LeadCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeadCode()
    {
        return isset($this->LeadCode) ? $this->LeadCode : null;
    }
    /**
     * Set LeadCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leadCode
     * @return \optsoapsdk\StructType\UpdateLead
     */
    public function setLeadCode($leadCode = null)
    {
        // validation for constraint: string
        if (!is_null($leadCode) && !is_string($leadCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leadCode, true), gettype($leadCode)), __LINE__);
        }
        if (is_null($leadCode) || (is_array($leadCode) && empty($leadCode))) {
            unset($this->LeadCode);
        } else {
            $this->LeadCode = $leadCode;
        }
        return $this;
    }
    /**
     * Get AgentID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgentID()
    {
        return isset($this->AgentID) ? $this->AgentID : null;
    }
    /**
     * Set AgentID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agentID
     * @return \optsoapsdk\StructType\UpdateLead
     */
    public function setAgentID($agentID = null)
    {
        // validation for constraint: string
        if (!is_null($agentID) && !is_string($agentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentID, true), gettype($agentID)), __LINE__);
        }
        if (is_null($agentID) || (is_array($agentID) && empty($agentID))) {
            unset($this->AgentID);
        } else {
            $this->AgentID = $agentID;
        }
        return $this;
    }
    /**
     * Get AccountType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountType()
    {
        return isset($this->AccountType) ? $this->AccountType : null;
    }
    /**
     * Set AccountType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountType
     * @return \optsoapsdk\StructType\UpdateLead
     */
    public function setAccountType($accountType = null)
    {
        // validation for constraint: string
        if (!is_null($accountType) && !is_string($accountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountType, true), gettype($accountType)), __LINE__);
        }
        if (is_null($accountType) || (is_array($accountType) && empty($accountType))) {
            unset($this->AccountType);
        } else {
            $this->AccountType = $accountType;
        }
        return $this;
    }
    /**
     * Get EmailIDSignedInWith value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailIDSignedInWith()
    {
        return isset($this->EmailIDSignedInWith) ? $this->EmailIDSignedInWith : null;
    }
    /**
     * Set EmailIDSignedInWith value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailIDSignedInWith
     * @return \optsoapsdk\StructType\UpdateLead
     */
    public function setEmailIDSignedInWith($emailIDSignedInWith = null)
    {
        // validation for constraint: string
        if (!is_null($emailIDSignedInWith) && !is_string($emailIDSignedInWith)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailIDSignedInWith, true), gettype($emailIDSignedInWith)), __LINE__);
        }
        if (is_null($emailIDSignedInWith) || (is_array($emailIDSignedInWith) && empty($emailIDSignedInWith))) {
            unset($this->EmailIDSignedInWith);
        } else {
            $this->EmailIDSignedInWith = $emailIDSignedInWith;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \optsoapsdk\StructType\UpdateLead
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Comments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComments()
    {
        return isset($this->Comments) ? $this->Comments : null;
    }
    /**
     * Set Comments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comments
     * @return \optsoapsdk\StructType\UpdateLead
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        if (is_null($comments) || (is_array($comments) && empty($comments))) {
            unset($this->Comments);
        } else {
            $this->Comments = $comments;
        }
        return $this;
    }
}
