<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Search ServiceType
 */
$search = new \ServiceType\Search($options);
/**
 * Sample call for search operation/method
 */
if ($search->search(new \StructType\Client(), new \StructType\Domaine(), $methode, $borneInf, $nbDomaine, new \StructType\Identifiant()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Login ServiceType
 */
$login = new \ServiceType\Login($options);
/**
 * Sample call for login operation/method
 */
if ($login->login($identifiant, $password) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Samples for Domaine ServiceType
 */
$domaine = new \ServiceType\Domaine($options);
/**
 * Sample call for domaineCheck operation/method
 */
if ($domaine->domaineCheck(new \StructType\Client(), new \StructType\Vector()) !== false) {
    print_r($domaine->getResult());
} else {
    print_r($domaine->getLastError());
}
/**
 * Sample call for domaineInfo operation/method
 */
if ($domaine->domaineInfo(new \StructType\Client(), $domaine, new \StructType\Identifiant()) !== false) {
    print_r($domaine->getResult());
} else {
    print_r($domaine->getLastError());
}
/**
 * Sample call for domaineCreate operation/method
 */
if ($domaine->domaineCreate(new \StructType\Client(), new \StructType\Domaine(), $periode, new \StructType\Identifiant(), $trackId, new \StructType\AskBy()) !== false) {
    print_r($domaine->getResult());
} else {
    print_r($domaine->getLastError());
}
/**
 * Sample call for domaineRenew operation/method
 */
if ($domaine->domaineRenew(new \StructType\Client(), $domaine, $periode, new \StructType\Identifiant(), $trackId, new \StructType\AskBy()) !== false) {
    print_r($domaine->getResult());
} else {
    print_r($domaine->getLastError());
}
/**
 * Sample call for domaineUpdate operation/method
 */
if ($domaine->domaineUpdate(new \StructType\Client(), new \StructType\Domaine(), new \StructType\Identifiant(), $trackId, new \StructType\AskBy()) !== false) {
    print_r($domaine->getResult());
} else {
    print_r($domaine->getLastError());
}
/**
 * Sample call for domaineTransfer operation/method
 */
if ($domaine->domaineTransfer(new \StructType\Client(), new \StructType\Domaine(), $password, new \StructType\Identifiant(), $trackId, new \StructType\AskBy()) !== false) {
    print_r($domaine->getResult());
} else {
    print_r($domaine->getLastError());
}
/**
 * Sample call for domaineDelete operation/method
 */
if ($domaine->domaineDelete(new \StructType\Client(), $domaine, new \StructType\Identifiant(), $trackId, new \StructType\AskBy()) !== false) {
    print_r($domaine->getResult());
} else {
    print_r($domaine->getLastError());
}
/**
 * Sample call for domaineWhois operation/method
 */
if ($domaine->domaineWhois(new \StructType\Client(), $domaine) !== false) {
    print_r($domaine->getResult());
} else {
    print_r($domaine->getLastError());
}
/**
 * Sample call for domaineWhoisTexte operation/method
 */
if ($domaine->domaineWhoisTexte(new \StructType\Client(), $domaine) !== false) {
    print_r($domaine->getResult());
} else {
    print_r($domaine->getLastError());
}
/**
 * Sample call for domaineSetNoRenew operation/method
 */
if ($domaine->domaineSetNoRenew(new \StructType\Client(), $domaine, new \StructType\Identifiant(), $trackId, new \StructType\AskBy()) !== false) {
    print_r($domaine->getResult());
} else {
    print_r($domaine->getLastError());
}
/**
 * Sample call for domaineRemoveNoRenew operation/method
 */
if ($domaine->domaineRemoveNoRenew(new \StructType\Client(), $domaine, new \StructType\Identifiant(), $trackId, new \StructType\AskBy()) !== false) {
    print_r($domaine->getResult());
} else {
    print_r($domaine->getLastError());
}
/**
 * Sample call for domaineTransferUpdateAuthcod operation/method
 */
if ($domaine->domaineTransferUpdateAuthcod(new \StructType\Client(), $ticket, $domaine, $password, new \StructType\Identifiant()) !== false) {
    print_r($domaine->getResult());
} else {
    print_r($domaine->getLastError());
}
/**
 * Samples for Status ServiceType
 */
$status = new \ServiceType\Status($options);
/**
 * Sample call for statusTicket operation/method
 */
if ($status->statusTicket(new \StructType\Client(), $ticket, new \StructType\Identifiant()) !== false) {
    print_r($status->getResult());
} else {
    print_r($status->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
/**
 * Sample call for sendPassword operation/method
 */
if ($send->sendPassword(new \StructType\Client(), $domaine, new \StructType\Identifiant(), $trackId, new \StructType\AskBy()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendPasswordCourrier operation/method
 */
if ($send->sendPasswordCourrier(new \StructType\Client(), $domaine, new \StructType\Identifiant(), $trackId, new \StructType\AskBy()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Mask ServiceType
 */
$mask = new \ServiceType\Mask($options);
/**
 * Sample call for maskDomaineContacts operation/method
 */
if ($mask->maskDomaineContacts(new \StructType\Client(), $domaine, new \StructType\Identifiant(), $trackId, new \StructType\AskBy()) !== false) {
    print_r($mask->getResult());
} else {
    print_r($mask->getLastError());
}
/**
 * Samples for Un ServiceType
 */
$un = new \ServiceType\Un($options);
/**
 * Sample call for unMaskDomaineContacts operation/method
 */
if ($un->unMaskDomaineContacts(new \StructType\Client(), $domaine, new \StructType\Identifiant(), $trackId, new \StructType\AskBy()) !== false) {
    print_r($un->getResult());
} else {
    print_r($un->getLastError());
}
/**
 * Samples for Lock ServiceType
 */
$lock = new \ServiceType\Lock($options);
/**
 * Sample call for lockDomaine operation/method
 */
if ($lock->lockDomaine(new \StructType\Client(), $domaine, new \StructType\Identifiant(), $trackId, new \StructType\AskBy()) !== false) {
    print_r($lock->getResult());
} else {
    print_r($lock->getLastError());
}
/**
 * Samples for Unlock ServiceType
 */
$unlock = new \ServiceType\Unlock($options);
/**
 * Sample call for unlockDomaine operation/method
 */
if ($unlock->unlockDomaine(new \StructType\Client(), $domaine, new \StructType\Identifiant(), $trackId, new \StructType\AskBy()) !== false) {
    print_r($unlock->getResult());
} else {
    print_r($unlock->getLastError());
}
/**
 * Samples for Logout ServiceType
 */
$logout = new \ServiceType\Logout($options);
/**
 * Sample call for logout operation/method
 */
if ($logout->logout(new \StructType\Client()) !== false) {
    print_r($logout->getResult());
} else {
    print_r($logout->getLastError());
}
/**
 * Samples for Acount ServiceType
 */
$acount = new \ServiceType\Acount($options);
/**
 * Sample call for acountBalance operation/method
 */
if ($acount->acountBalance(new \StructType\Client(), new \StructType\Identifiant()) !== false) {
    print_r($acount->getResult());
} else {
    print_r($acount->getLastError());
}
/**
 * Samples for Ticket ServiceType
 */
$ticket = new \ServiceType\Ticket($options);
/**
 * Sample call for ticketQuery operation/method
 */
if ($ticket->ticketQuery(new \StructType\Client(), $domaine, $borneInf, $nbDomaine, new \StructType\Identifiant()) !== false) {
    print_r($ticket->getResult());
} else {
    print_r($ticket->getLastError());
}
/**
 * Samples for Convert ServiceType
 */
$convert = new \ServiceType\Convert($options);
/**
 * Sample call for convertTicketToDomaine operation/method
 */
if ($convert->convertTicketToDomaine(new \StructType\Client(), $ticket, new \StructType\Identifiant()) !== false) {
    print_r($convert->getResult());
} else {
    print_r($convert->getLastError());
}
/**
 * Sample call for convertErrorToText operation/method
 */
if ($convert->convertErrorToText(new \StructType\Client(), $error, $langue) !== false) {
    print_r($convert->getResult());
} else {
    print_r($convert->getLastError());
}
/**
 * Samples for Ack ServiceType
 */
$ack = new \ServiceType\Ack($options);
/**
 * Sample call for ackMessage operation/method
 */
if ($ack->ackMessage(new \StructType\Client(), $idMessages, new \StructType\Identifiant()) !== false) {
    print_r($ack->getResult());
} else {
    print_r($ack->getLastError());
}
/**
 * Samples for Read ServiceType
 */
$read = new \ServiceType\Read($options);
/**
 * Sample call for readMessageFromTicket operation/method
 */
if ($read->readMessageFromTicket(new \StructType\Client(), $ticket, new \StructType\Identifiant(), $borneInf, $nbMessage) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for readUnreadMessage operation/method
 */
if ($read->readUnreadMessage(new \StructType\Client(), new \StructType\Identifiant(), $borneInf, $nbMessage) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Samples for Annuler ServiceType
 */
$annuler = new \ServiceType\Annuler($options);
/**
 * Sample call for annulerTicket operation/method
 */
if ($annuler->annulerTicket(new \StructType\Client(), $ticket, $domaine, $message, new \StructType\Identifiant()) !== false) {
    print_r($annuler->getResult());
} else {
    print_r($annuler->getLastError());
}
/**
 * Samples for Repondre ServiceType
 */
$repondre = new \ServiceType\Repondre($options);
/**
 * Sample call for repondreNotification operation/method
 */
if ($repondre->repondreNotification(new \StructType\Client(), $md5, $rep, new \StructType\Identifiant()) !== false) {
    print_r($repondre->getResult());
} else {
    print_r($repondre->getLastError());
}
