<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticket StructType
 * @subpackage Structs
 */
class Ticket extends AbstractStructBase
{
    /**
     * The idTicket
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $idTicket;
    /**
     * The entite
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $entite;
    /**
     * The typeEntite
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $typeEntite;
    /**
     * The etat
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $etat;
    /**
     * The cmd
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cmd;
    /**
     * The typeCmd
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $typeCmd;
    /**
     * The createDate
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $createDate;
    /**
     * The createBy
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $createBy;
    /**
     * The askBy
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $askBy;
    /**
     * The trackId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $trackId;
    /**
     * The dateLimit
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $dateLimit;
    /**
     * The closeDate
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $closeDate;
    /**
     * The finalRep
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $finalRep;
    /**
     * The causes
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $causes;
    /**
     * The notification
     * Meta information extracted from the WSDL
     * - arrayType: tns1:Notification[]
     * - base: soapenc:Array
     * - nillable: true
     * - ref: soapenc:arrayType
     * @var \StructType\Notification[]
     */
    public $notification;
    /**
     * The metadata
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $metadata;
    /**
     * Constructor method for Ticket
     * @uses Ticket::setIdTicket()
     * @uses Ticket::setEntite()
     * @uses Ticket::setTypeEntite()
     * @uses Ticket::setEtat()
     * @uses Ticket::setCmd()
     * @uses Ticket::setTypeCmd()
     * @uses Ticket::setCreateDate()
     * @uses Ticket::setCreateBy()
     * @uses Ticket::setAskBy()
     * @uses Ticket::setTrackId()
     * @uses Ticket::setDateLimit()
     * @uses Ticket::setCloseDate()
     * @uses Ticket::setFinalRep()
     * @uses Ticket::setCauses()
     * @uses Ticket::setNotification()
     * @uses Ticket::setMetadata()
     * @param int $idTicket
     * @param string $entite
     * @param string $typeEntite
     * @param string $etat
     * @param string $cmd
     * @param string $typeCmd
     * @param string $createDate
     * @param string $createBy
     * @param string $askBy
     * @param string $trackId
     * @param string $dateLimit
     * @param string $closeDate
     * @param string $finalRep
     * @param string $causes
     * @param \StructType\Notification[] $notification
     * @param string $metadata
     */
    public function __construct($idTicket = null, $entite = null, $typeEntite = null, $etat = null, $cmd = null, $typeCmd = null, $createDate = null, $createBy = null, $askBy = null, $trackId = null, $dateLimit = null, $closeDate = null, $finalRep = null, $causes = null, array $notification = array(), $metadata = null)
    {
        $this
            ->setIdTicket($idTicket)
            ->setEntite($entite)
            ->setTypeEntite($typeEntite)
            ->setEtat($etat)
            ->setCmd($cmd)
            ->setTypeCmd($typeCmd)
            ->setCreateDate($createDate)
            ->setCreateBy($createBy)
            ->setAskBy($askBy)
            ->setTrackId($trackId)
            ->setDateLimit($dateLimit)
            ->setCloseDate($closeDate)
            ->setFinalRep($finalRep)
            ->setCauses($causes)
            ->setNotification($notification)
            ->setMetadata($metadata);
    }
    /**
     * Get idTicket value
     * @return int|null
     */
    public function getIdTicket()
    {
        return $this->idTicket;
    }
    /**
     * Set idTicket value
     * @param int $idTicket
     * @return \StructType\Ticket
     */
    public function setIdTicket($idTicket = null)
    {
        // validation for constraint: int
        if (!is_null($idTicket) && !(is_int($idTicket) || ctype_digit($idTicket))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idTicket, true), gettype($idTicket)), __LINE__);
        }
        $this->idTicket = $idTicket;
        return $this;
    }
    /**
     * Get entite value
     * @return string|null
     */
    public function getEntite()
    {
        return $this->entite;
    }
    /**
     * Set entite value
     * @param string $entite
     * @return \StructType\Ticket
     */
    public function setEntite($entite = null)
    {
        // validation for constraint: string
        if (!is_null($entite) && !is_string($entite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entite, true), gettype($entite)), __LINE__);
        }
        $this->entite = $entite;
        return $this;
    }
    /**
     * Get typeEntite value
     * @return string|null
     */
    public function getTypeEntite()
    {
        return $this->typeEntite;
    }
    /**
     * Set typeEntite value
     * @uses \EnumType\TypeEntite::valueIsValid()
     * @uses \EnumType\TypeEntite::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeEntite
     * @return \StructType\Ticket
     */
    public function setTypeEntite($typeEntite = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeEntite::valueIsValid($typeEntite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeEntite', is_array($typeEntite) ? implode(', ', $typeEntite) : var_export($typeEntite, true), implode(', ', \EnumType\TypeEntite::getValidValues())), __LINE__);
        }
        $this->typeEntite = $typeEntite;
        return $this;
    }
    /**
     * Get etat value
     * @return string|null
     */
    public function getEtat()
    {
        return $this->etat;
    }
    /**
     * Set etat value
     * @uses \EnumType\EtatTicket::valueIsValid()
     * @uses \EnumType\EtatTicket::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $etat
     * @return \StructType\Ticket
     */
    public function setEtat($etat = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EtatTicket::valueIsValid($etat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EtatTicket', is_array($etat) ? implode(', ', $etat) : var_export($etat, true), implode(', ', \EnumType\EtatTicket::getValidValues())), __LINE__);
        }
        $this->etat = $etat;
        return $this;
    }
    /**
     * Get cmd value
     * @return string|null
     */
    public function getCmd()
    {
        return $this->cmd;
    }
    /**
     * Set cmd value
     * @param string $cmd
     * @return \StructType\Ticket
     */
    public function setCmd($cmd = null)
    {
        // validation for constraint: string
        if (!is_null($cmd) && !is_string($cmd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmd, true), gettype($cmd)), __LINE__);
        }
        $this->cmd = $cmd;
        return $this;
    }
    /**
     * Get typeCmd value
     * @return string|null
     */
    public function getTypeCmd()
    {
        return $this->typeCmd;
    }
    /**
     * Set typeCmd value
     * @param string $typeCmd
     * @return \StructType\Ticket
     */
    public function setTypeCmd($typeCmd = null)
    {
        // validation for constraint: string
        if (!is_null($typeCmd) && !is_string($typeCmd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeCmd, true), gettype($typeCmd)), __LINE__);
        }
        $this->typeCmd = $typeCmd;
        return $this;
    }
    /**
     * Get createDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->createDate;
    }
    /**
     * Set createDate value
     * @param string $createDate
     * @return \StructType\Ticket
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->createDate = $createDate;
        return $this;
    }
    /**
     * Get createBy value
     * @return string|null
     */
    public function getCreateBy()
    {
        return $this->createBy;
    }
    /**
     * Set createBy value
     * @param string $createBy
     * @return \StructType\Ticket
     */
    public function setCreateBy($createBy = null)
    {
        // validation for constraint: string
        if (!is_null($createBy) && !is_string($createBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createBy, true), gettype($createBy)), __LINE__);
        }
        $this->createBy = $createBy;
        return $this;
    }
    /**
     * Get askBy value
     * @return string|null
     */
    public function getAskBy()
    {
        return $this->askBy;
    }
    /**
     * Set askBy value
     * @param string $askBy
     * @return \StructType\Ticket
     */
    public function setAskBy($askBy = null)
    {
        // validation for constraint: string
        if (!is_null($askBy) && !is_string($askBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($askBy, true), gettype($askBy)), __LINE__);
        }
        $this->askBy = $askBy;
        return $this;
    }
    /**
     * Get trackId value
     * @return string|null
     */
    public function getTrackId()
    {
        return $this->trackId;
    }
    /**
     * Set trackId value
     * @param string $trackId
     * @return \StructType\Ticket
     */
    public function setTrackId($trackId = null)
    {
        // validation for constraint: string
        if (!is_null($trackId) && !is_string($trackId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackId, true), gettype($trackId)), __LINE__);
        }
        $this->trackId = $trackId;
        return $this;
    }
    /**
     * Get dateLimit value
     * @return string|null
     */
    public function getDateLimit()
    {
        return $this->dateLimit;
    }
    /**
     * Set dateLimit value
     * @param string $dateLimit
     * @return \StructType\Ticket
     */
    public function setDateLimit($dateLimit = null)
    {
        // validation for constraint: string
        if (!is_null($dateLimit) && !is_string($dateLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateLimit, true), gettype($dateLimit)), __LINE__);
        }
        $this->dateLimit = $dateLimit;
        return $this;
    }
    /**
     * Get closeDate value
     * @return string|null
     */
    public function getCloseDate()
    {
        return $this->closeDate;
    }
    /**
     * Set closeDate value
     * @param string $closeDate
     * @return \StructType\Ticket
     */
    public function setCloseDate($closeDate = null)
    {
        // validation for constraint: string
        if (!is_null($closeDate) && !is_string($closeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($closeDate, true), gettype($closeDate)), __LINE__);
        }
        $this->closeDate = $closeDate;
        return $this;
    }
    /**
     * Get finalRep value
     * @return string|null
     */
    public function getFinalRep()
    {
        return $this->finalRep;
    }
    /**
     * Set finalRep value
     * @param string $finalRep
     * @return \StructType\Ticket
     */
    public function setFinalRep($finalRep = null)
    {
        // validation for constraint: string
        if (!is_null($finalRep) && !is_string($finalRep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($finalRep, true), gettype($finalRep)), __LINE__);
        }
        $this->finalRep = $finalRep;
        return $this;
    }
    /**
     * Get causes value
     * @return string|null
     */
    public function getCauses()
    {
        return $this->causes;
    }
    /**
     * Set causes value
     * @param string $causes
     * @return \StructType\Ticket
     */
    public function setCauses($causes = null)
    {
        // validation for constraint: string
        if (!is_null($causes) && !is_string($causes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($causes, true), gettype($causes)), __LINE__);
        }
        $this->causes = $causes;
        return $this;
    }
    /**
     * Get notification value
     * @return \StructType\Notification[]|null
     */
    public function getNotification()
    {
        return $this->notification;
    }
    /**
     * This method is responsible for validating the values passed to the setNotification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNotification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNotificationForArrayConstraintsFromSetNotification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketNotificationItem) {
            // validation for constraint: itemType
            if (!$ticketNotificationItem instanceof \StructType\Notification) {
                $invalidValues[] = is_object($ticketNotificationItem) ? get_class($ticketNotificationItem) : sprintf('%s(%s)', gettype($ticketNotificationItem), var_export($ticketNotificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The notification property can only contain items of type \StructType\Notification, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set notification value
     * @throws \InvalidArgumentException
     * @param \StructType\Notification[] $notification
     * @return \StructType\Ticket
     */
    public function setNotification(array $notification = array())
    {
        // validation for constraint: array
        if ('' !== ($notificationArrayErrorMessage = self::validateNotificationForArrayConstraintsFromSetNotification($notification))) {
            throw new \InvalidArgumentException($notificationArrayErrorMessage, __LINE__);
        }
        $this->notification = $notification;
        return $this;
    }
    /**
     * Add item to notification value
     * @throws \InvalidArgumentException
     * @param \StructType\Notification $item
     * @return \StructType\Ticket
     */
    public function addToNotification(\StructType\Notification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Notification) {
            throw new \InvalidArgumentException(sprintf('The notification property can only contain items of type \StructType\Notification, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->notification[] = $item;
        return $this;
    }
    /**
     * Get metadata value
     * @return string|null
     */
    public function getMetadata()
    {
        return $this->metadata;
    }
    /**
     * Set metadata value
     * @param string $metadata
     * @return \StructType\Ticket
     */
    public function setMetadata($metadata = null)
    {
        // validation for constraint: string
        if (!is_null($metadata) && !is_string($metadata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($metadata, true), gettype($metadata)), __LINE__);
        }
        $this->metadata = $metadata;
        return $this;
    }
}
