<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SimpleTicket StructType
 * @subpackage Structs
 */
class SimpleTicket extends AbstractStructBase
{
    /**
     * The idTicket
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $idTicket;
    /**
     * The entite
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $entite;
    /**
     * The typeEntite
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $typeEntite;
    /**
     * The etat
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $etat;
    /**
     * The cmd
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cmd;
    /**
     * The createDate
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $createDate;
    /**
     * The closeDate
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $closeDate;
    /**
     * The trackId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $trackId;
    /**
     * The askBy
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $askBy;
    /**
     * The metadata
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $metadata;
    /**
     * The causes
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $causes;
    /**
     * The totalTicket
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $totalTicket;
    /**
     * Constructor method for SimpleTicket
     * @uses SimpleTicket::setIdTicket()
     * @uses SimpleTicket::setEntite()
     * @uses SimpleTicket::setTypeEntite()
     * @uses SimpleTicket::setEtat()
     * @uses SimpleTicket::setCmd()
     * @uses SimpleTicket::setCreateDate()
     * @uses SimpleTicket::setCloseDate()
     * @uses SimpleTicket::setTrackId()
     * @uses SimpleTicket::setAskBy()
     * @uses SimpleTicket::setMetadata()
     * @uses SimpleTicket::setCauses()
     * @uses SimpleTicket::setTotalTicket()
     * @param string $idTicket
     * @param string $entite
     * @param string $typeEntite
     * @param string $etat
     * @param string $cmd
     * @param string $createDate
     * @param string $closeDate
     * @param string $trackId
     * @param string $askBy
     * @param string $metadata
     * @param string $causes
     * @param int $totalTicket
     */
    public function __construct($idTicket = null, $entite = null, $typeEntite = null, $etat = null, $cmd = null, $createDate = null, $closeDate = null, $trackId = null, $askBy = null, $metadata = null, $causes = null, $totalTicket = null)
    {
        $this
            ->setIdTicket($idTicket)
            ->setEntite($entite)
            ->setTypeEntite($typeEntite)
            ->setEtat($etat)
            ->setCmd($cmd)
            ->setCreateDate($createDate)
            ->setCloseDate($closeDate)
            ->setTrackId($trackId)
            ->setAskBy($askBy)
            ->setMetadata($metadata)
            ->setCauses($causes)
            ->setTotalTicket($totalTicket);
    }
    /**
     * Get idTicket value
     * @return string|null
     */
    public function getIdTicket()
    {
        return $this->idTicket;
    }
    /**
     * Set idTicket value
     * @param string $idTicket
     * @return \StructType\SimpleTicket
     */
    public function setIdTicket($idTicket = null)
    {
        // validation for constraint: string
        if (!is_null($idTicket) && !is_string($idTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idTicket, true), gettype($idTicket)), __LINE__);
        }
        $this->idTicket = $idTicket;
        return $this;
    }
    /**
     * Get entite value
     * @return string|null
     */
    public function getEntite()
    {
        return $this->entite;
    }
    /**
     * Set entite value
     * @param string $entite
     * @return \StructType\SimpleTicket
     */
    public function setEntite($entite = null)
    {
        // validation for constraint: string
        if (!is_null($entite) && !is_string($entite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entite, true), gettype($entite)), __LINE__);
        }
        $this->entite = $entite;
        return $this;
    }
    /**
     * Get typeEntite value
     * @return string|null
     */
    public function getTypeEntite()
    {
        return $this->typeEntite;
    }
    /**
     * Set typeEntite value
     * @uses \EnumType\TypeEntite::valueIsValid()
     * @uses \EnumType\TypeEntite::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeEntite
     * @return \StructType\SimpleTicket
     */
    public function setTypeEntite($typeEntite = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeEntite::valueIsValid($typeEntite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeEntite', is_array($typeEntite) ? implode(', ', $typeEntite) : var_export($typeEntite, true), implode(', ', \EnumType\TypeEntite::getValidValues())), __LINE__);
        }
        $this->typeEntite = $typeEntite;
        return $this;
    }
    /**
     * Get etat value
     * @return string|null
     */
    public function getEtat()
    {
        return $this->etat;
    }
    /**
     * Set etat value
     * @uses \EnumType\EtatTicket::valueIsValid()
     * @uses \EnumType\EtatTicket::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $etat
     * @return \StructType\SimpleTicket
     */
    public function setEtat($etat = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EtatTicket::valueIsValid($etat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EtatTicket', is_array($etat) ? implode(', ', $etat) : var_export($etat, true), implode(', ', \EnumType\EtatTicket::getValidValues())), __LINE__);
        }
        $this->etat = $etat;
        return $this;
    }
    /**
     * Get cmd value
     * @return string|null
     */
    public function getCmd()
    {
        return $this->cmd;
    }
    /**
     * Set cmd value
     * @param string $cmd
     * @return \StructType\SimpleTicket
     */
    public function setCmd($cmd = null)
    {
        // validation for constraint: string
        if (!is_null($cmd) && !is_string($cmd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmd, true), gettype($cmd)), __LINE__);
        }
        $this->cmd = $cmd;
        return $this;
    }
    /**
     * Get createDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->createDate;
    }
    /**
     * Set createDate value
     * @param string $createDate
     * @return \StructType\SimpleTicket
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->createDate = $createDate;
        return $this;
    }
    /**
     * Get closeDate value
     * @return string|null
     */
    public function getCloseDate()
    {
        return $this->closeDate;
    }
    /**
     * Set closeDate value
     * @param string $closeDate
     * @return \StructType\SimpleTicket
     */
    public function setCloseDate($closeDate = null)
    {
        // validation for constraint: string
        if (!is_null($closeDate) && !is_string($closeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($closeDate, true), gettype($closeDate)), __LINE__);
        }
        $this->closeDate = $closeDate;
        return $this;
    }
    /**
     * Get trackId value
     * @return string|null
     */
    public function getTrackId()
    {
        return $this->trackId;
    }
    /**
     * Set trackId value
     * @param string $trackId
     * @return \StructType\SimpleTicket
     */
    public function setTrackId($trackId = null)
    {
        // validation for constraint: string
        if (!is_null($trackId) && !is_string($trackId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackId, true), gettype($trackId)), __LINE__);
        }
        $this->trackId = $trackId;
        return $this;
    }
    /**
     * Get askBy value
     * @return string|null
     */
    public function getAskBy()
    {
        return $this->askBy;
    }
    /**
     * Set askBy value
     * @param string $askBy
     * @return \StructType\SimpleTicket
     */
    public function setAskBy($askBy = null)
    {
        // validation for constraint: string
        if (!is_null($askBy) && !is_string($askBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($askBy, true), gettype($askBy)), __LINE__);
        }
        $this->askBy = $askBy;
        return $this;
    }
    /**
     * Get metadata value
     * @return string|null
     */
    public function getMetadata()
    {
        return $this->metadata;
    }
    /**
     * Set metadata value
     * @param string $metadata
     * @return \StructType\SimpleTicket
     */
    public function setMetadata($metadata = null)
    {
        // validation for constraint: string
        if (!is_null($metadata) && !is_string($metadata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($metadata, true), gettype($metadata)), __LINE__);
        }
        $this->metadata = $metadata;
        return $this;
    }
    /**
     * Get causes value
     * @return string|null
     */
    public function getCauses()
    {
        return $this->causes;
    }
    /**
     * Set causes value
     * @param string $causes
     * @return \StructType\SimpleTicket
     */
    public function setCauses($causes = null)
    {
        // validation for constraint: string
        if (!is_null($causes) && !is_string($causes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($causes, true), gettype($causes)), __LINE__);
        }
        $this->causes = $causes;
        return $this;
    }
    /**
     * Get totalTicket value
     * @return int|null
     */
    public function getTotalTicket()
    {
        return $this->totalTicket;
    }
    /**
     * Set totalTicket value
     * @param int $totalTicket
     * @return \StructType\SimpleTicket
     */
    public function setTotalTicket($totalTicket = null)
    {
        // validation for constraint: int
        if (!is_null($totalTicket) && !(is_int($totalTicket) || ctype_digit($totalTicket))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalTicket, true), gettype($totalTicket)), __LINE__);
        }
        $this->totalTicket = $totalTicket;
        return $this;
    }
}
