<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SimpleDomaine StructType
 * @subpackage Structs
 */
class SimpleDomaine extends AbstractStructBase
{
    /**
     * The domaine
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $domaine;
    /**
     * The etat
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $etat;
    /**
     * The created
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $created;
    /**
     * The duedate
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $duedate;
    /**
     * The owner
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Vector
     */
    public $owner;
    /**
     * The adm
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Vector
     */
    public $adm;
    /**
     * The tec
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Vector
     */
    public $tec;
    /**
     * The bill
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Vector
     */
    public $bill;
    /**
     * The dns
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Vector
     */
    public $dns;
    /**
     * The hold
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $hold;
    /**
     * The lock
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $lock;
    /**
     * The totalDomaine
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $totalDomaine;
    /**
     * Constructor method for SimpleDomaine
     * @uses SimpleDomaine::setDomaine()
     * @uses SimpleDomaine::setEtat()
     * @uses SimpleDomaine::setCreated()
     * @uses SimpleDomaine::setDuedate()
     * @uses SimpleDomaine::setOwner()
     * @uses SimpleDomaine::setAdm()
     * @uses SimpleDomaine::setTec()
     * @uses SimpleDomaine::setBill()
     * @uses SimpleDomaine::setDns()
     * @uses SimpleDomaine::setHold()
     * @uses SimpleDomaine::setLock()
     * @uses SimpleDomaine::setTotalDomaine()
     * @param string $domaine
     * @param string $etat
     * @param string $created
     * @param string $duedate
     * @param \StructType\Vector $owner
     * @param \StructType\Vector $adm
     * @param \StructType\Vector $tec
     * @param \StructType\Vector $bill
     * @param \StructType\Vector $dns
     * @param bool $hold
     * @param bool $lock
     * @param int $totalDomaine
     */
    public function __construct($domaine = null, $etat = null, $created = null, $duedate = null, \StructType\Vector $owner = null, \StructType\Vector $adm = null, \StructType\Vector $tec = null, \StructType\Vector $bill = null, \StructType\Vector $dns = null, $hold = null, $lock = null, $totalDomaine = null)
    {
        $this
            ->setDomaine($domaine)
            ->setEtat($etat)
            ->setCreated($created)
            ->setDuedate($duedate)
            ->setOwner($owner)
            ->setAdm($adm)
            ->setTec($tec)
            ->setBill($bill)
            ->setDns($dns)
            ->setHold($hold)
            ->setLock($lock)
            ->setTotalDomaine($totalDomaine);
    }
    /**
     * Get domaine value
     * @return string|null
     */
    public function getDomaine()
    {
        return $this->domaine;
    }
    /**
     * Set domaine value
     * @param string $domaine
     * @return \StructType\SimpleDomaine
     */
    public function setDomaine($domaine = null)
    {
        // validation for constraint: string
        if (!is_null($domaine) && !is_string($domaine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domaine, true), gettype($domaine)), __LINE__);
        }
        $this->domaine = $domaine;
        return $this;
    }
    /**
     * Get etat value
     * @return string|null
     */
    public function getEtat()
    {
        return $this->etat;
    }
    /**
     * Set etat value
     * @uses \EnumType\EtatDomaine::valueIsValid()
     * @uses \EnumType\EtatDomaine::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $etat
     * @return \StructType\SimpleDomaine
     */
    public function setEtat($etat = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EtatDomaine::valueIsValid($etat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EtatDomaine', is_array($etat) ? implode(', ', $etat) : var_export($etat, true), implode(', ', \EnumType\EtatDomaine::getValidValues())), __LINE__);
        }
        $this->etat = $etat;
        return $this;
    }
    /**
     * Get created value
     * @return string|null
     */
    public function getCreated()
    {
        return $this->created;
    }
    /**
     * Set created value
     * @param string $created
     * @return \StructType\SimpleDomaine
     */
    public function setCreated($created = null)
    {
        // validation for constraint: string
        if (!is_null($created) && !is_string($created)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($created, true), gettype($created)), __LINE__);
        }
        $this->created = $created;
        return $this;
    }
    /**
     * Get duedate value
     * @return string|null
     */
    public function getDuedate()
    {
        return $this->duedate;
    }
    /**
     * Set duedate value
     * @param string $duedate
     * @return \StructType\SimpleDomaine
     */
    public function setDuedate($duedate = null)
    {
        // validation for constraint: string
        if (!is_null($duedate) && !is_string($duedate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duedate, true), gettype($duedate)), __LINE__);
        }
        $this->duedate = $duedate;
        return $this;
    }
    /**
     * Get owner value
     * @return \StructType\Vector|null
     */
    public function getOwner()
    {
        return $this->owner;
    }
    /**
     * Set owner value
     * @param \StructType\Vector $owner
     * @return \StructType\SimpleDomaine
     */
    public function setOwner(\StructType\Vector $owner = null)
    {
        $this->owner = $owner;
        return $this;
    }
    /**
     * Get adm value
     * @return \StructType\Vector|null
     */
    public function getAdm()
    {
        return $this->adm;
    }
    /**
     * Set adm value
     * @param \StructType\Vector $adm
     * @return \StructType\SimpleDomaine
     */
    public function setAdm(\StructType\Vector $adm = null)
    {
        $this->adm = $adm;
        return $this;
    }
    /**
     * Get tec value
     * @return \StructType\Vector|null
     */
    public function getTec()
    {
        return $this->tec;
    }
    /**
     * Set tec value
     * @param \StructType\Vector $tec
     * @return \StructType\SimpleDomaine
     */
    public function setTec(\StructType\Vector $tec = null)
    {
        $this->tec = $tec;
        return $this;
    }
    /**
     * Get bill value
     * @return \StructType\Vector|null
     */
    public function getBill()
    {
        return $this->bill;
    }
    /**
     * Set bill value
     * @param \StructType\Vector $bill
     * @return \StructType\SimpleDomaine
     */
    public function setBill(\StructType\Vector $bill = null)
    {
        $this->bill = $bill;
        return $this;
    }
    /**
     * Get dns value
     * @return \StructType\Vector|null
     */
    public function getDns()
    {
        return $this->dns;
    }
    /**
     * Set dns value
     * @param \StructType\Vector $dns
     * @return \StructType\SimpleDomaine
     */
    public function setDns(\StructType\Vector $dns = null)
    {
        $this->dns = $dns;
        return $this;
    }
    /**
     * Get hold value
     * @return bool|null
     */
    public function getHold()
    {
        return $this->hold;
    }
    /**
     * Set hold value
     * @param bool $hold
     * @return \StructType\SimpleDomaine
     */
    public function setHold($hold = null)
    {
        // validation for constraint: boolean
        if (!is_null($hold) && !is_bool($hold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hold, true), gettype($hold)), __LINE__);
        }
        $this->hold = $hold;
        return $this;
    }
    /**
     * Get lock value
     * @return bool|null
     */
    public function getLock()
    {
        return $this->lock;
    }
    /**
     * Set lock value
     * @param bool $lock
     * @return \StructType\SimpleDomaine
     */
    public function setLock($lock = null)
    {
        // validation for constraint: boolean
        if (!is_null($lock) && !is_bool($lock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lock, true), gettype($lock)), __LINE__);
        }
        $this->lock = $lock;
        return $this;
    }
    /**
     * Get totalDomaine value
     * @return int|null
     */
    public function getTotalDomaine()
    {
        return $this->totalDomaine;
    }
    /**
     * Set totalDomaine value
     * @param int $totalDomaine
     * @return \StructType\SimpleDomaine
     */
    public function setTotalDomaine($totalDomaine = null)
    {
        // validation for constraint: int
        if (!is_null($totalDomaine) && !(is_int($totalDomaine) || ctype_digit($totalDomaine))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalDomaine, true), gettype($totalDomaine)), __LINE__);
        }
        $this->totalDomaine = $totalDomaine;
        return $this;
    }
}
