<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseVectorMessage StructType
 * @subpackage Structs
 */
class ResponseVectorMessage extends Response
{
    /**
     * The error
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Error
     */
    public $error;
    /**
     * The response
     * Meta information extracted from the WSDL
     * - arrayType: tns1:Message[]
     * - base: soapenc:Array
     * - nillable: true
     * - ref: soapenc:arrayType
     * @var \StructType\Message[]
     */
    public $response;
    /**
     * The successfull
     * @var bool
     */
    public $successfull;
    /**
     * Constructor method for ResponseVectorMessage
     * @uses ResponseVectorMessage::setError()
     * @uses ResponseVectorMessage::setResponse()
     * @uses ResponseVectorMessage::setSuccessfull()
     * @param \StructType\Error $error
     * @param \StructType\Message[] $response
     * @param bool $successfull
     */
    public function __construct(\StructType\Error $error = null, array $response = array(), $successfull = null)
    {
        $this
            ->setError($error)
            ->setResponse($response)
            ->setSuccessfull($successfull);
    }
    /**
     * Get error value
     * @return \StructType\Error|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param \StructType\Error $error
     * @return \StructType\ResponseVectorMessage
     */
    public function setError(\StructType\Error $error = null)
    {
        $this->error = $error;
        return $this;
    }
    /**
     * Get response value
     * @return \StructType\Message[]|null
     */
    public function getResponse()
    {
        return $this->response;
    }
    /**
     * This method is responsible for validating the values passed to the setResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResponse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResponseForArrayConstraintsFromSetResponse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responseVectorMessageResponseItem) {
            // validation for constraint: itemType
            if (!$responseVectorMessageResponseItem instanceof \StructType\Message) {
                $invalidValues[] = is_object($responseVectorMessageResponseItem) ? get_class($responseVectorMessageResponseItem) : sprintf('%s(%s)', gettype($responseVectorMessageResponseItem), var_export($responseVectorMessageResponseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The response property can only contain items of type \StructType\Message, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set response value
     * @throws \InvalidArgumentException
     * @param \StructType\Message[] $response
     * @return \StructType\ResponseVectorMessage
     */
    public function setResponse(array $response = array())
    {
        // validation for constraint: array
        if ('' !== ($responseArrayErrorMessage = self::validateResponseForArrayConstraintsFromSetResponse($response))) {
            throw new \InvalidArgumentException($responseArrayErrorMessage, __LINE__);
        }
        $this->response = $response;
        return $this;
    }
    /**
     * Add item to response value
     * @throws \InvalidArgumentException
     * @param \StructType\Message $item
     * @return \StructType\ResponseVectorMessage
     */
    public function addToResponse(\StructType\Message $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Message) {
            throw new \InvalidArgumentException(sprintf('The response property can only contain items of type \StructType\Message, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->response[] = $item;
        return $this;
    }
    /**
     * Get successfull value
     * @return bool|null
     */
    public function getSuccessfull()
    {
        return $this->successfull;
    }
    /**
     * Set successfull value
     * @param bool $successfull
     * @return \StructType\ResponseVectorMessage
     */
    public function setSuccessfull($successfull = null)
    {
        // validation for constraint: boolean
        if (!is_null($successfull) && !is_bool($successfull)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($successfull, true), gettype($successfull)), __LINE__);
        }
        $this->successfull = $successfull;
        return $this;
    }
}
