<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseNotification StructType
 * @subpackage Structs
 */
class ResponseNotification extends Response
{
    /**
     * The error
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Error
     */
    public $error;
    /**
     * The response
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Notification
     */
    public $response;
    /**
     * The successfull
     * @var bool
     */
    public $successfull;
    /**
     * Constructor method for ResponseNotification
     * @uses ResponseNotification::setError()
     * @uses ResponseNotification::setResponse()
     * @uses ResponseNotification::setSuccessfull()
     * @param \StructType\Error $error
     * @param \StructType\Notification $response
     * @param bool $successfull
     */
    public function __construct(\StructType\Error $error = null, \StructType\Notification $response = null, $successfull = null)
    {
        $this
            ->setError($error)
            ->setResponse($response)
            ->setSuccessfull($successfull);
    }
    /**
     * Get error value
     * @return \StructType\Error|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param \StructType\Error $error
     * @return \StructType\ResponseNotification
     */
    public function setError(\StructType\Error $error = null)
    {
        $this->error = $error;
        return $this;
    }
    /**
     * Get response value
     * @return \StructType\Notification|null
     */
    public function getResponse()
    {
        return $this->response;
    }
    /**
     * Set response value
     * @param \StructType\Notification $response
     * @return \StructType\ResponseNotification
     */
    public function setResponse(\StructType\Notification $response = null)
    {
        $this->response = $response;
        return $this;
    }
    /**
     * Get successfull value
     * @return bool|null
     */
    public function getSuccessfull()
    {
        return $this->successfull;
    }
    /**
     * Set successfull value
     * @param bool $successfull
     * @return \StructType\ResponseNotification
     */
    public function setSuccessfull($successfull = null)
    {
        // validation for constraint: boolean
        if (!is_null($successfull) && !is_bool($successfull)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($successfull, true), gettype($successfull)), __LINE__);
        }
        $this->successfull = $successfull;
        return $this;
    }
}
