<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseInteger StructType
 * @subpackage Structs
 */
class ResponseInteger extends Response
{
    /**
     * The error
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Error
     */
    public $error;
    /**
     * The response
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $response;
    /**
     * The successfull
     * @var bool
     */
    public $successfull;
    /**
     * Constructor method for ResponseInteger
     * @uses ResponseInteger::setError()
     * @uses ResponseInteger::setResponse()
     * @uses ResponseInteger::setSuccessfull()
     * @param \StructType\Error $error
     * @param int $response
     * @param bool $successfull
     */
    public function __construct(\StructType\Error $error = null, $response = null, $successfull = null)
    {
        $this
            ->setError($error)
            ->setResponse($response)
            ->setSuccessfull($successfull);
    }
    /**
     * Get error value
     * @return \StructType\Error|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param \StructType\Error $error
     * @return \StructType\ResponseInteger
     */
    public function setError(\StructType\Error $error = null)
    {
        $this->error = $error;
        return $this;
    }
    /**
     * Get response value
     * @return int|null
     */
    public function getResponse()
    {
        return $this->response;
    }
    /**
     * Set response value
     * @param int $response
     * @return \StructType\ResponseInteger
     */
    public function setResponse($response = null)
    {
        // validation for constraint: int
        if (!is_null($response) && !(is_int($response) || ctype_digit($response))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($response, true), gettype($response)), __LINE__);
        }
        $this->response = $response;
        return $this;
    }
    /**
     * Get successfull value
     * @return bool|null
     */
    public function getSuccessfull()
    {
        return $this->successfull;
    }
    /**
     * Set successfull value
     * @param bool $successfull
     * @return \StructType\ResponseInteger
     */
    public function setSuccessfull($successfull = null)
    {
        // validation for constraint: boolean
        if (!is_null($successfull) && !is_bool($successfull)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($successfull, true), gettype($successfull)), __LINE__);
        }
        $this->successfull = $successfull;
        return $this;
    }
}
