<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseClient StructType
 * @subpackage Structs
 */
class ResponseClient extends Response
{
    /**
     * The error
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Error
     */
    public $error;
    /**
     * The response
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Client
     */
    public $response;
    /**
     * The successfull
     * @var bool
     */
    public $successfull;
    /**
     * Constructor method for ResponseClient
     * @uses ResponseClient::setError()
     * @uses ResponseClient::setResponse()
     * @uses ResponseClient::setSuccessfull()
     * @param \StructType\Error $error
     * @param \StructType\Client $response
     * @param bool $successfull
     */
    public function __construct(\StructType\Error $error = null, \StructType\Client $response = null, $successfull = null)
    {
        $this
            ->setError($error)
            ->setResponse($response)
            ->setSuccessfull($successfull);
    }
    /**
     * Get error value
     * @return \StructType\Error|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param \StructType\Error $error
     * @return \StructType\ResponseClient
     */
    public function setError(\StructType\Error $error = null)
    {
        $this->error = $error;
        return $this;
    }
    /**
     * Get response value
     * @return \StructType\Client|null
     */
    public function getResponse()
    {
        return $this->response;
    }
    /**
     * Set response value
     * @param \StructType\Client $response
     * @return \StructType\ResponseClient
     */
    public function setResponse(\StructType\Client $response = null)
    {
        $this->response = $response;
        return $this;
    }
    /**
     * Get successfull value
     * @return bool|null
     */
    public function getSuccessfull()
    {
        return $this->successfull;
    }
    /**
     * Set successfull value
     * @param bool $successfull
     * @return \StructType\ResponseClient
     */
    public function setSuccessfull($successfull = null)
    {
        // validation for constraint: boolean
        if (!is_null($successfull) && !is_bool($successfull)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($successfull, true), gettype($successfull)), __LINE__);
        }
        $this->successfull = $successfull;
        return $this;
    }
}
