<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseBoolean StructType
 * @subpackage Structs
 */
class ResponseBoolean extends Response
{
    /**
     * The error
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Error
     */
    public $error;
    /**
     * The response
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $response;
    /**
     * The successfull
     * @var bool
     */
    public $successfull;
    /**
     * Constructor method for ResponseBoolean
     * @uses ResponseBoolean::setError()
     * @uses ResponseBoolean::setResponse()
     * @uses ResponseBoolean::setSuccessfull()
     * @param \StructType\Error $error
     * @param bool $response
     * @param bool $successfull
     */
    public function __construct(\StructType\Error $error = null, $response = null, $successfull = null)
    {
        $this
            ->setError($error)
            ->setResponse($response)
            ->setSuccessfull($successfull);
    }
    /**
     * Get error value
     * @return \StructType\Error|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param \StructType\Error $error
     * @return \StructType\ResponseBoolean
     */
    public function setError(\StructType\Error $error = null)
    {
        $this->error = $error;
        return $this;
    }
    /**
     * Get response value
     * @return bool|null
     */
    public function getResponse()
    {
        return $this->response;
    }
    /**
     * Set response value
     * @param bool $response
     * @return \StructType\ResponseBoolean
     */
    public function setResponse($response = null)
    {
        // validation for constraint: boolean
        if (!is_null($response) && !is_bool($response)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($response, true), gettype($response)), __LINE__);
        }
        $this->response = $response;
        return $this;
    }
    /**
     * Get successfull value
     * @return bool|null
     */
    public function getSuccessfull()
    {
        return $this->successfull;
    }
    /**
     * Set successfull value
     * @param bool $successfull
     * @return \StructType\ResponseBoolean
     */
    public function setSuccessfull($successfull = null)
    {
        // validation for constraint: boolean
        if (!is_null($successfull) && !is_bool($successfull)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($successfull, true), gettype($successfull)), __LINE__);
        }
        $this->successfull = $successfull;
        return $this;
    }
}
