<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Notification StructType
 * @subpackage Structs
 */
class Notification extends AbstractStructBase
{
    /**
     * The etat
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $etat;
    /**
     * The createDate
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $createDate;
    /**
     * The createBy
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $createBy;
    /**
     * The dateLimit
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $dateLimit;
    /**
     * The contact
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $contact;
    /**
     * The typecontact
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $typecontact;
    /**
     * The erreur
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $erreur;
    /**
     * The response
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $response;
    /**
     * The rpBy
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $rpBy;
    /**
     * The rpDate
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $rpDate;
    /**
     * The rpId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $rpId;
    /**
     * The respDefault
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $respDefault;
    /**
     * Constructor method for Notification
     * @uses Notification::setEtat()
     * @uses Notification::setCreateDate()
     * @uses Notification::setCreateBy()
     * @uses Notification::setDateLimit()
     * @uses Notification::setContact()
     * @uses Notification::setTypecontact()
     * @uses Notification::setErreur()
     * @uses Notification::setResponse()
     * @uses Notification::setRpBy()
     * @uses Notification::setRpDate()
     * @uses Notification::setRpId()
     * @uses Notification::setRespDefault()
     * @param string $etat
     * @param string $createDate
     * @param string $createBy
     * @param string $dateLimit
     * @param string $contact
     * @param string $typecontact
     * @param string $erreur
     * @param string $response
     * @param string $rpBy
     * @param string $rpDate
     * @param string $rpId
     * @param string $respDefault
     */
    public function __construct($etat = null, $createDate = null, $createBy = null, $dateLimit = null, $contact = null, $typecontact = null, $erreur = null, $response = null, $rpBy = null, $rpDate = null, $rpId = null, $respDefault = null)
    {
        $this
            ->setEtat($etat)
            ->setCreateDate($createDate)
            ->setCreateBy($createBy)
            ->setDateLimit($dateLimit)
            ->setContact($contact)
            ->setTypecontact($typecontact)
            ->setErreur($erreur)
            ->setResponse($response)
            ->setRpBy($rpBy)
            ->setRpDate($rpDate)
            ->setRpId($rpId)
            ->setRespDefault($respDefault);
    }
    /**
     * Get etat value
     * @return string|null
     */
    public function getEtat()
    {
        return $this->etat;
    }
    /**
     * Set etat value
     * @uses \EnumType\EtatNotification::valueIsValid()
     * @uses \EnumType\EtatNotification::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $etat
     * @return \StructType\Notification
     */
    public function setEtat($etat = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EtatNotification::valueIsValid($etat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EtatNotification', is_array($etat) ? implode(', ', $etat) : var_export($etat, true), implode(', ', \EnumType\EtatNotification::getValidValues())), __LINE__);
        }
        $this->etat = $etat;
        return $this;
    }
    /**
     * Get createDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->createDate;
    }
    /**
     * Set createDate value
     * @param string $createDate
     * @return \StructType\Notification
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->createDate = $createDate;
        return $this;
    }
    /**
     * Get createBy value
     * @return string|null
     */
    public function getCreateBy()
    {
        return $this->createBy;
    }
    /**
     * Set createBy value
     * @param string $createBy
     * @return \StructType\Notification
     */
    public function setCreateBy($createBy = null)
    {
        // validation for constraint: string
        if (!is_null($createBy) && !is_string($createBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createBy, true), gettype($createBy)), __LINE__);
        }
        $this->createBy = $createBy;
        return $this;
    }
    /**
     * Get dateLimit value
     * @return string|null
     */
    public function getDateLimit()
    {
        return $this->dateLimit;
    }
    /**
     * Set dateLimit value
     * @param string $dateLimit
     * @return \StructType\Notification
     */
    public function setDateLimit($dateLimit = null)
    {
        // validation for constraint: string
        if (!is_null($dateLimit) && !is_string($dateLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateLimit, true), gettype($dateLimit)), __LINE__);
        }
        $this->dateLimit = $dateLimit;
        return $this;
    }
    /**
     * Get contact value
     * @return string|null
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * Set contact value
     * @param string $contact
     * @return \StructType\Notification
     */
    public function setContact($contact = null)
    {
        // validation for constraint: string
        if (!is_null($contact) && !is_string($contact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contact, true), gettype($contact)), __LINE__);
        }
        $this->contact = $contact;
        return $this;
    }
    /**
     * Get typecontact value
     * @return string|null
     */
    public function getTypecontact()
    {
        return $this->typecontact;
    }
    /**
     * Set typecontact value
     * @uses \EnumType\TypeContact::valueIsValid()
     * @uses \EnumType\TypeContact::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typecontact
     * @return \StructType\Notification
     */
    public function setTypecontact($typecontact = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeContact::valueIsValid($typecontact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeContact', is_array($typecontact) ? implode(', ', $typecontact) : var_export($typecontact, true), implode(', ', \EnumType\TypeContact::getValidValues())), __LINE__);
        }
        $this->typecontact = $typecontact;
        return $this;
    }
    /**
     * Get erreur value
     * @return string|null
     */
    public function getErreur()
    {
        return $this->erreur;
    }
    /**
     * Set erreur value
     * @param string $erreur
     * @return \StructType\Notification
     */
    public function setErreur($erreur = null)
    {
        // validation for constraint: string
        if (!is_null($erreur) && !is_string($erreur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erreur, true), gettype($erreur)), __LINE__);
        }
        $this->erreur = $erreur;
        return $this;
    }
    /**
     * Get response value
     * @return string|null
     */
    public function getResponse()
    {
        return $this->response;
    }
    /**
     * Set response value
     * @param string $response
     * @return \StructType\Notification
     */
    public function setResponse($response = null)
    {
        // validation for constraint: string
        if (!is_null($response) && !is_string($response)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($response, true), gettype($response)), __LINE__);
        }
        $this->response = $response;
        return $this;
    }
    /**
     * Get rpBy value
     * @return string|null
     */
    public function getRpBy()
    {
        return $this->rpBy;
    }
    /**
     * Set rpBy value
     * @param string $rpBy
     * @return \StructType\Notification
     */
    public function setRpBy($rpBy = null)
    {
        // validation for constraint: string
        if (!is_null($rpBy) && !is_string($rpBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rpBy, true), gettype($rpBy)), __LINE__);
        }
        $this->rpBy = $rpBy;
        return $this;
    }
    /**
     * Get rpDate value
     * @return string|null
     */
    public function getRpDate()
    {
        return $this->rpDate;
    }
    /**
     * Set rpDate value
     * @param string $rpDate
     * @return \StructType\Notification
     */
    public function setRpDate($rpDate = null)
    {
        // validation for constraint: string
        if (!is_null($rpDate) && !is_string($rpDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rpDate, true), gettype($rpDate)), __LINE__);
        }
        $this->rpDate = $rpDate;
        return $this;
    }
    /**
     * Get rpId value
     * @return string|null
     */
    public function getRpId()
    {
        return $this->rpId;
    }
    /**
     * Set rpId value
     * @param string $rpId
     * @return \StructType\Notification
     */
    public function setRpId($rpId = null)
    {
        // validation for constraint: string
        if (!is_null($rpId) && !is_string($rpId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rpId, true), gettype($rpId)), __LINE__);
        }
        $this->rpId = $rpId;
        return $this;
    }
    /**
     * Get respDefault value
     * @return string|null
     */
    public function getRespDefault()
    {
        return $this->respDefault;
    }
    /**
     * Set respDefault value
     * @param string $respDefault
     * @return \StructType\Notification
     */
    public function setRespDefault($respDefault = null)
    {
        // validation for constraint: string
        if (!is_null($respDefault) && !is_string($respDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($respDefault, true), gettype($respDefault)), __LINE__);
        }
        $this->respDefault = $respDefault;
        return $this;
    }
}
