<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Message StructType
 * @subpackage Structs
 */
class Message extends AbstractStructBase
{
    /**
     * The idMessageQueue
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $idMessageQueue;
    /**
     * The destinataires
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $destinataires;
    /**
     * The ticket
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $ticket;
    /**
     * The answer
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $answer;
    /**
     * The action
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $action;
    /**
     * The typeAction
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $typeAction;
    /**
     * The bal
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $bal;
    /**
     * The typeMessage
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $typeMessage;
    /**
     * The typeEtat
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $typeEtat;
    /**
     * The etat
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $etat;
    /**
     * The cause
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cause;
    /**
     * The dateRead
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $dateRead;
    /**
     * Constructor method for Message
     * @uses Message::setIdMessageQueue()
     * @uses Message::setDestinataires()
     * @uses Message::setTicket()
     * @uses Message::setAnswer()
     * @uses Message::setAction()
     * @uses Message::setTypeAction()
     * @uses Message::setBal()
     * @uses Message::setTypeMessage()
     * @uses Message::setTypeEtat()
     * @uses Message::setEtat()
     * @uses Message::setCause()
     * @uses Message::setDateRead()
     * @param int $idMessageQueue
     * @param string $destinataires
     * @param int $ticket
     * @param string $answer
     * @param string $action
     * @param string $typeAction
     * @param string $bal
     * @param string $typeMessage
     * @param string $typeEtat
     * @param string $etat
     * @param string $cause
     * @param string $dateRead
     */
    public function __construct($idMessageQueue = null, $destinataires = null, $ticket = null, $answer = null, $action = null, $typeAction = null, $bal = null, $typeMessage = null, $typeEtat = null, $etat = null, $cause = null, $dateRead = null)
    {
        $this
            ->setIdMessageQueue($idMessageQueue)
            ->setDestinataires($destinataires)
            ->setTicket($ticket)
            ->setAnswer($answer)
            ->setAction($action)
            ->setTypeAction($typeAction)
            ->setBal($bal)
            ->setTypeMessage($typeMessage)
            ->setTypeEtat($typeEtat)
            ->setEtat($etat)
            ->setCause($cause)
            ->setDateRead($dateRead);
    }
    /**
     * Get idMessageQueue value
     * @return int|null
     */
    public function getIdMessageQueue()
    {
        return $this->idMessageQueue;
    }
    /**
     * Set idMessageQueue value
     * @param int $idMessageQueue
     * @return \StructType\Message
     */
    public function setIdMessageQueue($idMessageQueue = null)
    {
        // validation for constraint: int
        if (!is_null($idMessageQueue) && !(is_int($idMessageQueue) || ctype_digit($idMessageQueue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idMessageQueue, true), gettype($idMessageQueue)), __LINE__);
        }
        $this->idMessageQueue = $idMessageQueue;
        return $this;
    }
    /**
     * Get destinataires value
     * @return string|null
     */
    public function getDestinataires()
    {
        return $this->destinataires;
    }
    /**
     * Set destinataires value
     * @param string $destinataires
     * @return \StructType\Message
     */
    public function setDestinataires($destinataires = null)
    {
        // validation for constraint: string
        if (!is_null($destinataires) && !is_string($destinataires)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinataires, true), gettype($destinataires)), __LINE__);
        }
        $this->destinataires = $destinataires;
        return $this;
    }
    /**
     * Get ticket value
     * @return int|null
     */
    public function getTicket()
    {
        return $this->ticket;
    }
    /**
     * Set ticket value
     * @param int $ticket
     * @return \StructType\Message
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: int
        if (!is_null($ticket) && !(is_int($ticket) || ctype_digit($ticket))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->ticket = $ticket;
        return $this;
    }
    /**
     * Get answer value
     * @return string|null
     */
    public function getAnswer()
    {
        return $this->answer;
    }
    /**
     * Set answer value
     * @param string $answer
     * @return \StructType\Message
     */
    public function setAnswer($answer = null)
    {
        // validation for constraint: string
        if (!is_null($answer) && !is_string($answer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($answer, true), gettype($answer)), __LINE__);
        }
        $this->answer = $answer;
        return $this;
    }
    /**
     * Get action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->action;
    }
    /**
     * Set action value
     * @param string $action
     * @return \StructType\Message
     */
    public function setAction($action = null)
    {
        // validation for constraint: string
        if (!is_null($action) && !is_string($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($action, true), gettype($action)), __LINE__);
        }
        $this->action = $action;
        return $this;
    }
    /**
     * Get typeAction value
     * @return string|null
     */
    public function getTypeAction()
    {
        return $this->typeAction;
    }
    /**
     * Set typeAction value
     * @uses \EnumType\TypeAction::valueIsValid()
     * @uses \EnumType\TypeAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeAction
     * @return \StructType\Message
     */
    public function setTypeAction($typeAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeAction::valueIsValid($typeAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeAction', is_array($typeAction) ? implode(', ', $typeAction) : var_export($typeAction, true), implode(', ', \EnumType\TypeAction::getValidValues())), __LINE__);
        }
        $this->typeAction = $typeAction;
        return $this;
    }
    /**
     * Get bal value
     * @return string|null
     */
    public function getBal()
    {
        return $this->bal;
    }
    /**
     * Set bal value
     * @param string $bal
     * @return \StructType\Message
     */
    public function setBal($bal = null)
    {
        // validation for constraint: string
        if (!is_null($bal) && !is_string($bal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bal, true), gettype($bal)), __LINE__);
        }
        $this->bal = $bal;
        return $this;
    }
    /**
     * Get typeMessage value
     * @return string|null
     */
    public function getTypeMessage()
    {
        return $this->typeMessage;
    }
    /**
     * Set typeMessage value
     * @uses \EnumType\TypeMessage::valueIsValid()
     * @uses \EnumType\TypeMessage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeMessage
     * @return \StructType\Message
     */
    public function setTypeMessage($typeMessage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeMessage::valueIsValid($typeMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeMessage', is_array($typeMessage) ? implode(', ', $typeMessage) : var_export($typeMessage, true), implode(', ', \EnumType\TypeMessage::getValidValues())), __LINE__);
        }
        $this->typeMessage = $typeMessage;
        return $this;
    }
    /**
     * Get typeEtat value
     * @return string|null
     */
    public function getTypeEtat()
    {
        return $this->typeEtat;
    }
    /**
     * Set typeEtat value
     * @uses \EnumType\EtatTicket::valueIsValid()
     * @uses \EnumType\EtatTicket::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeEtat
     * @return \StructType\Message
     */
    public function setTypeEtat($typeEtat = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EtatTicket::valueIsValid($typeEtat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EtatTicket', is_array($typeEtat) ? implode(', ', $typeEtat) : var_export($typeEtat, true), implode(', ', \EnumType\EtatTicket::getValidValues())), __LINE__);
        }
        $this->typeEtat = $typeEtat;
        return $this;
    }
    /**
     * Get etat value
     * @return string|null
     */
    public function getEtat()
    {
        return $this->etat;
    }
    /**
     * Set etat value
     * @uses \EnumType\EtatMessage::valueIsValid()
     * @uses \EnumType\EtatMessage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $etat
     * @return \StructType\Message
     */
    public function setEtat($etat = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EtatMessage::valueIsValid($etat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EtatMessage', is_array($etat) ? implode(', ', $etat) : var_export($etat, true), implode(', ', \EnumType\EtatMessage::getValidValues())), __LINE__);
        }
        $this->etat = $etat;
        return $this;
    }
    /**
     * Get cause value
     * @return string|null
     */
    public function getCause()
    {
        return $this->cause;
    }
    /**
     * Set cause value
     * @param string $cause
     * @return \StructType\Message
     */
    public function setCause($cause = null)
    {
        // validation for constraint: string
        if (!is_null($cause) && !is_string($cause)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cause, true), gettype($cause)), __LINE__);
        }
        $this->cause = $cause;
        return $this;
    }
    /**
     * Get dateRead value
     * @return string|null
     */
    public function getDateRead()
    {
        return $this->dateRead;
    }
    /**
     * Set dateRead value
     * @param string $dateRead
     * @return \StructType\Message
     */
    public function setDateRead($dateRead = null)
    {
        // validation for constraint: string
        if (!is_null($dateRead) && !is_string($dateRead)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateRead, true), gettype($dateRead)), __LINE__);
        }
        $this->dateRead = $dateRead;
        return $this;
    }
}
